package com.pcloud.common.core.mq;

import org.apache.activemq.command.ActiveMQQueue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.pcloud.common.core.enums.MqQueueEnum;

/**
 * 
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年11月14日,上午10:59:55 @版本：1.0
 */
@Configuration
public class ActiveMqQueue {

	/**
	 * 音视频转换消息队列
	 * 
	 * @return
	 */
	@Bean(name = "convertQueue")
	public ActiveMQQueue getConvertQueue() {
		return new ActiveMQQueue("convert");
	}

	/**
	 * 标签使用量消息队列
	 * 
	 * @return
	 */
	@Bean(name = "labelUsedQueue")
	public ActiveMQQueue getLabelUsedQueue() {
		return new ActiveMQQueue("labelUsed");
	}

	/**
	 * 日志消息队列
	 * 
	 * @return
	 */
	@Bean(name = "logQueue")
	public ActiveMQQueue getLogQueue() {
		return new ActiveMQQueue("log");
	}

	/**
	 * 系统消息消息队列
	 * 
	 * @return
	 */
	@Bean(name = "messageQueue")
	public ActiveMQQueue getMessageQueue() {
		return new ActiveMQQueue("message");
	}

	/**
	 * 周任务消息队列
	 * 
	 * @return
	 */
	@Bean(name = "weektaskQueue")
	public ActiveMQQueue getWeektaskQueue() {
		return new ActiveMQQueue("weektask");
	}

	/**
	 * 模板消息消息队列
	 * 
	 * @return
	 */
	@Bean(name = "templateQueue")
	public ActiveMQQueue getTemplateQueue() {
		return new ActiveMQQueue("template");
	}

	/**
	 * 用户行为消息队列
	 * 
	 * @return
	 */
	@Bean(name = "userActionQueue")
	public ActiveMQQueue getUserActionQueue() {
		return new ActiveMQQueue("userAction");
	}

	/**
	 * 用户漏斗流程队列
	 * 
	 * @return
	 */
	@Bean(name = "funnelFlowQueue")
	public ActiveMQQueue getFunnelFlowQueue() {
		return new ActiveMQQueue("funnelFlow");
	}

	/**
	 * 基金监控消息队列
	 * 
	 * @return
	 */
	@Bean(name = "fundQueue")
	public ActiveMQQueue getFundQueue() {
		return new ActiveMQQueue("fund");
	}

	/**
	 * 动态监控消息队列
	 *
	 * @return
	 */
	@Bean(name = "dynamicQueue")
	public ActiveMQQueue getDynamicQueue() {
		return new ActiveMQQueue("merchantDynamic");
	}

	/**
	 * 事件分析埋点
	 *
	 * @return
	 */
	@Bean(name = "frontEventQueue")
	public ActiveMQQueue getFrontEventQueue() {
		return new ActiveMQQueue("frontEvent");
	}

	/**
	 * 对外api队列
	 * 
	 * @author wangrui
	 * @date 10:28 2018/4/13
	 */
	@Bean(name = "exapiQueue")
	public ActiveMQQueue getExapiQueue() {
		return new ActiveMQQueue("exapi");
	}

	/**
	 * 文件转码(非音视频转码)
	 * 
	 * @return
	 */
	@Bean(name = "transcodeQueue")
	public ActiveMQQueue getTranscodeQueue() {
		return new ActiveMQQueue(MqQueueEnum.TRANSCODE.queueName);
	}

	/**
	 * 促销任务
	 *
	 * @return
	 */
	@Bean(name = "promotionTaskQueue")
	public ActiveMQQueue getPromotionTaskQueue() {
		return new ActiveMQQueue("promotionTask");
	}

	/**
	 * 促销终止
	 *
	 * @return
	 */
	@Bean(name = "promotionTerminateQueue")
	public ActiveMQQueue getPromotionTerminateQueue() {
		return new ActiveMQQueue("promotionTerminate");
	}

}
