package com.pcloud.common.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

import java.io.Serializable;

/**
 * @描述：服务响应实体类
 * @作者：shichunshan
 * @创建时间：2016年5月17日,下午1:53:02 @版本：1.0
 */
@JsonInclude(value = Include.NON_NULL)
public class ResponseDto<T> implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9004186626234235043L;

	/**
	 * 默认操作成功，成功代码
	 */
	private static final int SUCCESS = 0;

	/**
	 * 默认成功消息
	 */
	private static final String SUCCESS_MSG = "操作成功！";

	/**
	 * 错误码
	 */
	private int errCode;

	/**
	 * 消息
	 */
	private String message;

	/**
	 * 数据
	 */
	private T data;

	/**
	 * 默认成功
	 */
	public ResponseDto() {
		super();
		this.errCode = SUCCESS;
		this.message = SUCCESS_MSG;
	}

	/**
	 * @param errCode
	 * @param message
	 */
	public ResponseDto(int errCode, String message) {
		super();
		this.errCode = errCode;
		this.message = message;
	}

	/**
	 * @param errCode
	 * @param message
	 * @param data
	 */
	public ResponseDto(int errCode, String message, T data) {
		super();
		this.errCode = errCode;
		this.message = message;
		this.data = data;
	}

	/**
	 * 默认成功
	 * 
	 * @param data
	 */
	public ResponseDto(T data) {
		super();
		this.errCode = SUCCESS;
		this.message = SUCCESS_MSG;
		this.data = data;
	}

	public int getErrCode() {
		return errCode;
	}

	public void setErrCode(int errCode) {
		this.errCode = errCode;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	@Override
	public String toString() {
		return "ResponseDto [errCode=" + errCode + ", message=" + message + ", data=" + data + "]";
	}

}
