package com.pcloud.common.page;

import java.io.Serializable;

/**
 * @描述：分页参数传递工具类.
 * @作者：DiSeng.H
 * @创建时间：2016年3月11日,下午3:59:25
 * @版本：1.0
 */
public class PageParam implements Serializable{

	private static final long serialVersionUID = 1609426288537400968L;
	private int pageNum; // 当前页数。
	private int numPerPage; // 每页记录数
	
	public PageParam() {
		super();
	}

	public PageParam(int pageNum, int numPerPage) {
		super();
		this.pageNum = pageNum;
		this.numPerPage = numPerPage;
	}

	/** 当前页数 */
	public int getPageNum() {
		return pageNum;
	}

	/** 当前页数 */
	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}

	/** 每页记录数 */
	public int getNumPerPage() {
		return numPerPage;
	}

	/** 每页记录数 */
	public void setNumPerPage(int numPerPage) {
		this.numPerPage = numPerPage;
	}

}
