/**
 * 
 */
package com.pcloud.common.utils.encode;

import java.net.URLEncoder;

/**
 * @描述：URL编码，只替换中文和一些特殊字符
 * @作者：songx
 * @创建时间：2017年8月4日,下午1:47:27 @版本：1.0
 */
public class ZSEncode {

	/**
	 * 判断是否是ascii 发现127 128 无用，果断去掉
	 * 
	 * @param ch
	 * @return
	 */
	public static boolean isAscii(char ch) {
		return ch <= 126;
	}

	/**
	 * 替换ascii中的一些特殊字符(不包括中文)
	 * 
	 * @param url
	 * @return
	 */
	public static String encodeURIChar(String url) {
		if (url == null) {
			return "";
		}
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < url.length(); i++) {
			char ch = url.charAt(i);
			if (isAscii(ch)) {
				convert(ch, sb);
			} else {
				sb.append(ch);
			}
		}
		return sb.toString();
	}

	/**
	 * 替换ascii中的一些特殊字符(仅中文)
	 * 
	 * @param url
	 * @return
	 */
	public static String encodeURIChinese(String url) {
		if (url == null) {
			return "";
		}
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < url.length(); i++) {
			char ch = url.charAt(i);
			if (isAscii(ch)) {
				sb.append(ch);
			} else {
				try {
					sb.append(URLEncoder.encode(Character.toString(ch), "UTF-8"));
				} catch (Exception e) {
					sb.append(ch);
				}
			}
		}
		return sb.toString();
	}

	/**
	 * 替换ascii中的一些特殊字符
	 * 
	 * @param url
	 * @return
	 */
	public static String encodeURI(String url) {
		if (url == null) {
			return "";
		}
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < url.length(); i++) {
			char ch = url.charAt(i);
			if (isAscii(ch)) {
				convert(ch, sb);
			} else {
				try {
					sb.append(URLEncoder.encode(Character.toString(ch), "UTF-8"));
				} catch (Exception e) {
					sb.append(ch);
				}
			}
		}
		return sb.toString();
	}

	/**
	 * 替换特殊字符
	 * 
	 * @param ch
	 * @param sb
	 */
	private static void convert(char ch, StringBuffer sb) {
		switch (ch) {
		case '"':
			sb.append("%22");
			break;
		case '+':
			sb.append("%2B");
			break;
		case '#':
			sb.append("%23");
			break;
		case '%':
			sb.append("%25");
			break;
		case '&':
			sb.append("%26");
			break;
		case '<':
			sb.append("%3C");
			break;
		case '=':
			sb.append("%3D");
			break;
		case '>':
			sb.append("%3E");
			break;
		case '?':
			sb.append("%3F");
			break;
		case '[':
			sb.append("%5B");
			break;
		case ']':
			sb.append("%5D");
			break;
		case '^':
			sb.append("%5E");
			break;
		case '`':
			sb.append("%60");
			break;
		case '{':
			sb.append("%7B");
			break;
		case '|':
			sb.append("%7C");
			break;
		case '}':
			sb.append("%7D");
			break;
		case '(':
			sb.append("%28");
			break;
		case ')':
			sb.append("%29");
			break;
		case ' ':
			sb.append("%20");
			break;
		default:
			sb.append(ch);
			break;
		}
	}

}
