/**
 *
 */
package com.pcloud.common.core.biz.impl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.KnowledgeUseQueueBiz;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.KnowledgeUseMQDTO;
import com.pcloud.common.exceptions.BizException;

/**
 * @author：songx
 * @date：2019/6/20,11:37
 */
@Component
public class KnowledgeUseQueueBizImpl implements KnowledgeUseQueueBiz {
    
    @Autowired
    private AmqpTemplate amqpTemplate;
    
    /**
     * 知识点标签使用QUEUE
     */
    @Override
    @ParamLog("知识点标签使用QUEUE")
    public void send(KnowledgeUseMQDTO knowledgeUseMQDTO) throws BizException {
        if (knowledgeUseMQDTO == null) {
            throw BizException.PARAM_IS_NULL;
        }
        amqpTemplate.convertAndSend(MQQueueConstant.KNOWLEDGE_USE, knowledgeUseMQDTO);
    }
    
}
