package com.pcloud.common.core.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @描述：SAYS作者动态
 * @作者：lucas
 * @创建时间：2017年12月14日,9:37
 * @版本：1.0
 */
public class DynamicDto implements Serializable {

    private static final long serialVersionUID = -1954714060978217900L;
    /**
     * 动态ID
     */
    private Long dynamicId;

    /**
     * 作者ID
     */
    private Long merchantId;

    /**
     * 动态类型
     */
    private String dynamicType;

    /**
     * 动态编码
     */
    private Long dynamicCode;

    /**
     * 动态主题
     */
    private String dynamicTheme;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 附件
     */
    private List<DynamicAccessoryDto> accessories;

    public Long getDynamicId() {
        return dynamicId;
    }

    public void setDynamicId(Long dynamicId) {
        this.dynamicId = dynamicId;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getDynamicType() {
        return dynamicType;
    }

    public void setDynamicType(String dynamicType) {
        this.dynamicType = dynamicType;
    }

    public Long getDynamicCode() {
        return dynamicCode;
    }

    public void setDynamicCode(Long dynamicCode) {
        this.dynamicCode = dynamicCode;
    }

    public String getDynamicTheme() {
        return dynamicTheme;
    }

    public void setDynamicTheme(String dynamicTheme) {
        this.dynamicTheme = dynamicTheme;
    }

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @XmlElement
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }


    public List<DynamicAccessoryDto> getAccessories() {
        return accessories;
    }

    public void setAccessories(List<DynamicAccessoryDto> accessories) {
        this.accessories = accessories;
    }

    @Override
    public String toString() {
        return "Dynamic{" + "dynamicId=" + dynamicId + ", merchantId=" + merchantId + ", dynamicType='" + dynamicType + '\'' + ", dynamicCode=" + dynamicCode + ", dynamicTheme='" + dynamicTheme
                + '\'' + ", createDate=" + createDate + ", accessories=" + accessories + '}';
    }
}
