package com.pcloud.common.core.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @描述： 用户行为动作模板消息dto
 * @作者： shuyh
 * @创建时间： 2017年5月23日
 * @版本：1.0
 */
public class UserActionMessageDto implements Serializable {

	private static final long serialVersionUID = -4132417523244980195L;
	
	/**
	 *  扫码 			SCAN_QR
	 *  浏览 			BROWSE
	 *  购买			BUY
	 *  评论 			COMMENT
	 *  点赞 			PRAISE
	 *  关注 			SUBSCIBE
	 *  发送消息 		SEND_MSG
	 */
	public static enum ActionType { SCAN_QR, BROWSE, BUY, COMMENT, PRAISE, SUBSCIBE, SEND_MSG };
	
	/**
	 *  商品		 	PRODUCT
	 *  商品资源 		PRORES
	 *  商品文章		PROART
	 *  应用			APPLY
	 *  应用资源		APPRES
	 *  应用文章		APPART
	 *  二维码		QRCODE
	 *  书刊/刊物		JOURNAL
	 *  公众号		OFFICIAL
	 */
	public static enum TargetType { PRODUCT, PRORES, PROART, APPLY, APPRES, APPART, RESOURCE, QRCODE, JOURNAL, OFFICIAL };
	
	/**
	 *  作者端		MERCHANT
	 *  编辑端		ADVISER
	 */
	public static enum TargetOriginType { MERCHANT, ADVISER };
	
    /**
     * (微信用户ID)
     */
    private Long userId;

    /**
     * (所属代理ID)
     */
    private Long agentId;

    /**
     * (渠道ID)
     */
    private Long channelId;

    /**
     * (用户所在公众号ID)
     */
    private Long officialAccountsId;

    /**
     * (行为动作类型)
     */
    private ActionType actionType;

    /**
     * (目标对象ID)
     */
    private Long targetId;

    /**
     * (目标对象类型)
     */
    private TargetType targetType;
    
    /**
     * (目标对象子类型)
     */
    private String targetSubtype;

    /**
     * (目标对象名称)
     */
    private String targetName;
    
    /**
	 * CONTENT_ID (目标内容ID)
	 */
    private Long contentId;

    /**
     * (行为内容)
     */
    private String actionContent;

    /**
     * (目标来源类型-作者端/编辑端)
     */
    private TargetOriginType targetOriginType;

    /**
     * (目标来源ID-作者ID/编辑ID)
     */
    private Long targetOriginId;
    
    /**
     * (行为时间)
     */
    private Date actionDate = new Date();

	/**
	 * 编辑ID
	 */
	private Long adviserId;
    
    public UserActionMessageDto() {
		super();
	}
    
	public UserActionMessageDto(Long userId, Long agentId, Long channelId,
			Long officialAccountsId, ActionType actionType, Long targetId,
			TargetType targetType, String targetName) {
		super();
		this.userId = userId;
		this.agentId = agentId;
		this.channelId = channelId;
		this.officialAccountsId = officialAccountsId;
		this.actionType = actionType;
		this.targetId = targetId;
		this.targetType = targetType;
		this.targetName = targetName;
	}
	
	public UserActionMessageDto(Long userId, Long agentId, Long channelId,
			Long officialAccountsId, ActionType actionType, Long targetId,
			TargetType targetType, String targetSubtype, String targetName) {
		super();
		this.userId = userId;
		this.agentId = agentId;
		this.channelId = channelId;
		this.officialAccountsId = officialAccountsId;
		this.actionType = actionType;
		this.targetId = targetId;
		this.targetType = targetType;
		this.targetSubtype = targetSubtype;
		this.targetName = targetName;
	}
	
	public UserActionMessageDto(Long userId, Long agentId, Long channelId,
			Long officialAccountsId, ActionType actionType, Long targetId,
			TargetType targetType, String targetName, String actionContent,
			TargetOriginType targetOriginType, Long targetOriginId) {
		super();
		this.userId = userId;
		this.agentId = agentId;
		this.channelId = channelId;
		this.officialAccountsId = officialAccountsId;
		this.actionType = actionType;
		this.targetId = targetId;
		this.targetType = targetType;
		this.targetName = targetName;
		this.actionContent = actionContent;
		this.targetOriginType = targetOriginType;
		this.targetOriginId = targetOriginId;
	}
	
	public UserActionMessageDto(Long userId, Long agentId, Long channelId,
			Long officialAccountsId, ActionType actionType, Long targetId,
			TargetType targetType, String targetSubtype, String targetName, 
			String actionContent, TargetOriginType targetOriginType, Long targetOriginId) {
		super();
		this.userId = userId;
		this.agentId = agentId;
		this.channelId = channelId;
		this.officialAccountsId = officialAccountsId;
		this.actionType = actionType;
		this.targetId = targetId;
		this.targetType = targetType;
		this.targetSubtype = targetSubtype;
		this.targetName = targetName;
		this.actionContent = actionContent;
		this.targetOriginType = targetOriginType;
		this.targetOriginId = targetOriginId;
	}
	
	public UserActionMessageDto(Long userId, Long agentId, Long channelId,
			Long officialAccountsId, ActionType actionType, Long targetId,
			TargetType targetType, String targetSubtype, String targetName, 
			Long contentId, String actionContent, 
			TargetOriginType targetOriginType, Long targetOriginId) {
		super();
		this.userId = userId;
		this.agentId = agentId;
		this.channelId = channelId;
		this.officialAccountsId = officialAccountsId;
		this.actionType = actionType;
		this.targetId = targetId;
		this.targetType = targetType;
		this.targetSubtype = targetSubtype;
		this.targetName = targetName;
		this.contentId = contentId;
		this.actionContent = actionContent;
		this.targetOriginType = targetOriginType;
		this.targetOriginId = targetOriginId;
	}

	public Long getAdviserId() {
		return adviserId;
	}

	public void setAdviserId(Long adviserId) {
		this.adviserId = adviserId;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Long getAgentId() {
		return agentId;
	}

	public void setAgentId(Long agentId) {
		this.agentId = agentId;
	}

	public Long getChannelId() {
		return channelId;
	}

	public void setChannelId(Long channelId) {
		this.channelId = channelId;
	}

	public Long getOfficialAccountsId() {
		return officialAccountsId;
	}

	public void setOfficialAccountsId(Long officialAccountsId) {
		this.officialAccountsId = officialAccountsId;
	}

	public Long getTargetId() {
		return targetId;
	}

	public void setTargetId(Long targetId) {
		this.targetId = targetId;
	}
	
	public String getTargetName() {
		return targetName;
	}

	public void setTargetName(String targetName) {
		this.targetName = targetName;
	}

	public String getActionContent() {
		return actionContent;
	}

	public void setActionContent(String actionContent) {
		this.actionContent = actionContent;
	}

	public Long getTargetOriginId() {
		return targetOriginId;
	}

	public void setTargetOriginId(Long targetOriginId) {
		this.targetOriginId = targetOriginId;
	}

	public ActionType getActionType() {
		return actionType;
	}

	public void setActionType(ActionType actionType) {
		this.actionType = actionType;
	}

	public TargetType getTargetType() {
		return targetType;
	}

	public void setTargetType(TargetType targetType) {
		this.targetType = targetType;
	}

	public TargetOriginType getTargetOriginType() {
		return targetOriginType;
	}

	public void setTargetOriginType(TargetOriginType targetOriginType) {
		this.targetOriginType = targetOriginType;
	}

	public Date getActionDate() {
		return actionDate;
	}

	public void setActionDate(Date actionDate) {
		this.actionDate = actionDate;
	}

	public String getTargetSubtype() {
		return targetSubtype;
	}

	public void setTargetSubtype(String targetSubtype) {
		this.targetSubtype = targetSubtype;
	}

	public Long getContentId() {
		return contentId;
	}

	public void setContentId(Long contentId) {
		this.contentId = contentId;
	}

	@Override
	public String toString() {
		return "UserActionMessageDto [userId=" + userId + ", agentId="
				+ agentId + ", channelId=" + channelId
				+ ", officialAccountsId=" + officialAccountsId
				+ ", actionType=" + actionType + ", targetId=" + targetId
				+ ", targetType=" + targetType + ", targetSubtype="
				+ targetSubtype + ", targetName=" + targetName + ", contentId="
				+ contentId + ", actionContent=" + actionContent
				+ ", targetOriginType=" + targetOriginType
				+ ", targetOriginId=" + targetOriginId + ", actionDate="
				+ actionDate + "]";
	}
}
