package com.pcloud.common.core.dto.dubbing;

import java.io.Serializable;
import java.util.List;

import com.alibaba.fastjson.JSONObject;

/**
 * 绘本配音资源DTO
 * 
 * @author：songx
 * @date：2018年12月5日,上午10:07:26
 */
public class DubbingDTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5639047705106025465L;

	/**
	 * 用户添加的问题文本(不超过5条)
	 */
	private List<SpeechDTO> speechDTOs;

	/**
	 * 待合成的背景音乐URL(不超过4条)
	 */
	private String[] bgms;

	/**
	 * 录音文件地址
	 */
	private String soundUrl;

	/**
	 * 来源类型
	 */
	private String fromType;

	/**
	 * 导语
	 */
	private String beforeText;

	/**
	 * 结束语
	 */
	private String afterText;

	/**
	 * 应用ID
	 */
	private Long appId;

	/**
	 * 编辑ID
	 */
	private Long adviserId;

	/**
	 * 音乐ID
	 */
	private Long musicId;

	public String getSoundUrl() {
		return soundUrl;
	}

	public void setSoundUrl(String soundUrl) {
		this.soundUrl = soundUrl;
	}

	public String getFromType() {
		return fromType;
	}

	public void setFromType(String fromType) {
		this.fromType = fromType;
	}

	public String getBeforeText() {
		return beforeText;
	}

	public void setBeforeText(String beforeText) {
		this.beforeText = beforeText;
	}

	public String getAfterText() {
		return afterText;
	}

	public void setAfterText(String afterText) {
		this.afterText = afterText;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getAdviserId() {
		return adviserId;
	}

	public void setAdviserId(Long adviserId) {
		this.adviserId = adviserId;
	}

	public Long getMusicId() {
		return musicId;
	}

	public void setMusicId(Long musicId) {
		this.musicId = musicId;
	}

	public List<SpeechDTO> getSpeechDTOs() {
		return speechDTOs;
	}

	public void setSpeechDTOs(List<SpeechDTO> speechDTOs) {
		this.speechDTOs = speechDTOs;
	}

	public String[] getBgms() {
		return bgms;
	}

	public void setBgms(String[] bgms) {
		this.bgms = bgms;
	}

	@Override
	public String toString() {
		return "DubbingDTO : " + JSONObject.toJSONString(this);
	}
}
