package com.pcloud.common.core.mybatis.cache.redis;

import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import org.apache.ibatis.cache.Cache;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RedisCacheImpl implements Cache {
    private final String id;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public static final Integer EXPIRE_SEC = 120;

    public RedisCacheImpl(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void putObject(Object o, Object o1) {
        JedisClusterUtils.setObject(o, o1, EXPIRE_SEC);
    }

    @Override
    public Object getObject(Object o) {
        return JedisClusterUtils.getObject(o);
    }

    @Override
    public Object removeObject(Object o) {
        return JedisClusterUtils.delObject(o);
    }

    @Override
    public void clear() {

    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return readWriteLock;
    }
}
