package com.pcloud.common.core.zipkin;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * 重新配置自定义采样率
 */
@Configuration
@AutoConfigureBefore(RefreshSamplerLocalProperties.class)
public class ZipkinConfig {
    //ZipkinAutoConfiguration使用@ConditionalOnMissingBean注解的，也就是容器中不存在这个Bean的时候，才初始化他自己默认的配置，可以重写他的配置
    @Bean
    public Sampler percentageLocalSampler(){
        SamplerLocalProperties samplerLocalProperties = new SamplerLocalProperties();
        return new PercentageLocalSampler(samplerLocalProperties);
    }
}
