package com.pcloud.common.core.biz;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.PromotionTaskDto;
import com.pcloud.common.exceptions.BizException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("promotionTaskQueueBiz")
public class PromotionTaskQueueBizImpl implements PromotionTaskQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 促销任务QUEUE
	 */
	@Override
	@ParamLog("促销任务QUEUE")
	public void send(PromotionTaskDto promotionTaskDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.PROMOTION_TASK, promotionTaskDto);
	}

}
