package com.pcloud.common.core.biz;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.PromotionTerminateDto;
import com.pcloud.common.exceptions.BizException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("promotionTerminateQueueBiz")
public class PromotionTerminateQueueBizImpl implements PromotionTerminateQueueBiz {
	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 促销终止QUEUE
	 */
	@Override
	@ParamLog("促销终止QUEUE")
	public void send(PromotionTerminateDto promotionTerminateDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.PROMOTION_TERMINATE, promotionTerminateDto);
	}

}
