/**
 * 
 */
package com.pcloud.common.dto;

import java.util.List;

import com.alibaba.fastjson.JSON;

import io.swagger.annotations.ApiModelProperty;

/**
 * 
 * @author：songx
 * @date：2018年9月17日,下午2:13:04
 */
public class CompressDTO extends BaseDto {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5422138980331341424L;

	@ApiModelProperty(name = "压缩包名称", dataType = "String")
	private String compressName;

	@ApiModelProperty(name = "压缩包文件集", dataType = "List<CompressFileDTO>")
	private List<CompressFileDTO> compressFileDTOs;

	public String getCompressName() {
		return compressName;
	}

	public void setCompressName(String compressName) {
		this.compressName = compressName;
	}

	public List<CompressFileDTO> getCompressFileDTOs() {
		return compressFileDTOs;
	}

	public void setCompressFileDTOs(List<CompressFileDTO> compressFileDTOs) {
		this.compressFileDTOs = compressFileDTOs;
	}

	@Override
	public String toString() {
		return "CompressDTO " + JSON.toJSONString(this);
	}

	public static class CompressFileDTO {

		@ApiModelProperty(name = "文件名称", dataType = "String")
		private String fileName;

		@ApiModelProperty(name = "文件地址", dataType = "String")
		private String fileUrl;

		@ApiModelProperty(name = "文件大小", dataType = "Long")
		private long fileSize;

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}

		public String getFileUrl() {
			return fileUrl;
		}

		public void setFileUrl(String fileUrl) {
			this.fileUrl = fileUrl;
		}

		public long getFileSize() {
			return fileSize;
		}

		public void setFileSize(long fileSize) {
			this.fileSize = fileSize;
		}

		@Override
		public String toString() {
			return "CompressFileDTO " + JSON.toJSONString(this);
		}
	}

}
