/**
 * 
 */
package com.pcloud.book.book.biz;

import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.BookAdviserUpdateTimeDTO;
import com.pcloud.book.book.dto.BookAssocCount;
import com.pcloud.book.book.dto.BookDetialDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookInfo4AnlysicsDTO;
import com.pcloud.book.book.dto.BookInfoAnalysicsDTO;
import com.pcloud.book.book.dto.BookInfoAndAuthStatusDTO;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.book.book.vo.BookSaleVO;
import com.pcloud.book.book.vo.ListNoAuthBookParam;
import com.pcloud.book.book.vo.ListNoAuthGroupBookParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @描述：书籍业务层接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:59:46 @版本：1.0
 */
public interface BookBiz {

	/**
	 * 创建书籍
	 * 
	 * @param book
	 *            图书基本信息
	 * @param systemCode 当事人角色
	 *            角色
	 * @throws BizException
	 */
	BookDto create(Book book, String systemCode) throws BizException;

	/**
	 * 修改书籍
	 * 
	 * @param book
	 *            图书基本信息
	 * @throws BizException
	 */
	void update(Book book) throws BizException;

	/**
	 * 修改书籍（编辑）
	 * @param book
	 *            图书基本信息
	 * @throws BizException
	 */
	BookDto updateByAdviser(Book book) throws BizException;

	/**
	 * 删除书籍
	 * 
	 * @param bookId
	 *            图书标识
	 * @param deleteUserId
	 *            删除用户标识
	 * @throws BizException
	 */
	void delete(Long bookId, Long deleteUserId) throws BizException;

	/**
	 * 批量删除书籍
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @param deleteUserId
	 *            删除人标识
	 * @return
	 */
	void deletes(String bookIds, Long deleteUserId) throws BizException;

	/**
	 * 获取书籍基础信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBaseById(Long bookId) throws BizException;

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 * @throws BizException
	 */
	BookDto getByIsbn(String isbn, String serialNumber) throws BizException;

	/**
	 * 判断ISBN是否存在
	 * 
	 * @param typeCode
	 *            图书标识
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 */
	Boolean isbnExists(String typeCode, String isbn, String serialNumber) throws BizException;

	/**
	 * 获取单个书籍基础信息(包含统计信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getById(Long bookId, Long adviserId, Long channelId) throws BizException;

    /**
     * 获取单个书籍基础信息(包含统计信息)
     *
     * @param bookId
     *            图书标识
     * @param adviserId
     *            编辑标识
     * @param channelId
     *            渠道标识
     * @return
     */
    BookDto getById4Platform(Long bookId, Long adviserId, Long channelId) throws BizException;

    /**
	 * 批量获取书籍信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 * @throws BizException
	 */
	Map<Long, BookDto> getListByIds(List<Long> bookIds) throws BizException;

	/**
	 * 批量获取书籍信息（书名 与书刊序号 封面图）
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 * @throws BizException
	 */
	Map<Long, BookDto> listBaseByIds(List<Long> bookIds) throws BizException;

	/**
	 * 批量获取书籍信息（书名 分类ID）
	 * @param bookDetialDTO
	 * @return
	 * @throws BizException
	 */
	Map<String,BookDto> listDetailByIds(BookDetialDTO bookDetialDTO)throws BizException;

	/**
	 * 获取书籍列表
	 * 
	 * @param isbn
	 * @param bookName
	 *            图书名称
	 * @param publish
	 *            出版社
	 * @param fundName
	 *            基金名称
	 * @param serialNumber
	 *            序列号
	 * @param isCurrentMonth
	 *            是否当前月
	 * @param currentPage
	 *            当前页
	 * @param numPerPage
	 *            每页条数
	 * 
	 * @return
	 * @throws BizException
	 */
	PageBeanNew<BookDto> getListPage(String isbn, String bookName, String publish, String fundName, String serialNumber,
			Integer isCurrentMonth, Integer currentPage, Integer numPerPage) throws BizException;

	/**
	 * 获取书籍列表(编辑)
	 * 
	 * @param paramMap
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param adviserId
	 *            编辑标识
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4Adviser(Map<String, Object> paramMap, PageParam pageParam, Long adviserId, Integer hasQrcode) throws BizException;

	/**
	 * 首页展示正在做的图书
	 * @param adviserId
	 * @param num
	 * @param isPrint
	 * @return
	 * @throws BizException
	 */
	List<BookDto> getList4Adviser(Long adviserId, Integer num, Boolean isPrint) throws BizException;
	/**
	 * 微信端获取书籍列表(编辑)
	 * 
	 * @param paramMap
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param adviserId
	 *            编辑标识
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4Wechat(Map<String, Object> paramMap, PageParam pageParam, Long adviserId);

	/**
	 * 获取书籍详细信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getDetailById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 根据名称获取ID
	 * 
	 * @param bookName
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByName(String bookName) throws BizException;
	
	/**
	 * 根据名称获取ID
	 * 
	 * @param bookName
	 *            图书名称
	 * @return
	 */
	List<Long> getIdsByName(String bookName, Long adviserId) throws BizException;

	/**
	 * 图书收益，获取单个书籍基础信息(包含统计信息)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	BookDto getById4Profit(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 判断ISBN是否存在,如果存在返回书籍信息
	 * 
	 * @param book
	 *            图书基本信息实体类
	 * @return
	 * @throws IOException
	 */
	BookDto isbnExistsOrGetInfo(Book book) throws BizException;

	/**
	 * 创建编辑书籍关联关系
	 * 
	 * @param book
	 *            图书基本信息实体类
	 * @return
	 */
	void setBookAdviserRelation(Book book);

	/**
	 * 获取书籍基本信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBaseInfoById4Wechat(Long bookId);

	/**
	 * 根据ISBN获取期刊分页列表
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param typeCode
	 *            类型编码
	 * @param isbn
	 *            ISBN号
	 * @param channelId
	 *            渠道ID
	 * @param wechatUserId
	 *            微信用户标识
	 * @return: PageBean
	 */
	PageBean getJournalPageByIsbn(PageParam pageParam, String typeCode, String isbn, Long channelId, Long wechatUserId);

	/**
	 * 获取书刊列表
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param channelId
	 *            渠道标识
	 * @param wechatUserId
	 *            微信用户标识
	 * @return
	 */
	PageBean listPage4Wechat(PageParam pageParam, Long channelId, Long wechatUserId);

	/**
	 * 根据ISBN码获取书籍详情（包含二维码个数，应用个数，商品个数）
	 * 
	 * @param isbn
	 * @param serialNumber
	 *            序列号
	 * @return
	 */
	BookDto getDetailByIsbn(String isbn, String serialNumber);

	/**
	 * 获取书刊信息
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param number
	 *            分页参数传递工具类
	 * @return
	 */
	List<Object> listBook(Long adviserId, Integer number);

	/**
	 * 修改书籍封面图
	 * 
	 * @param book
	 *            图书基本信息实体类
	 */
	void updateCoverImg(Book book);

	/**
	 * 书刊列表-出版端
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param paramMap
	 * @param agentId
	 *            代理标识
	 * @return
	 */
	PageBean listPage4Agent(PageParam pageParam, Map<String, Object> paramMap, Long agentId);

	/**
	 * 获取书刊信息-app 编辑
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param pageParam
	 *            分页参数传递工具类
	 * @return
	 */
	PageBean listBook4App(Long adviserId, PageParam pageParam, String bookName);

	/**
	 * 获取应用关联图书
	 * 
	 * @param appId
	 *            应用标识
	 * @param channelId
	 *            渠道标识
	 * @return
	 */
	List<BookDto> listBookByAppId(Long appId, Long channelId);

	/**
	 * 书刊回收站列表（30天内删除的书刊列表）
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param pageParam
	 *            分页参数传递工具类
	 * @return
	 */
	PageBean listPageDelete4Adviser(Long adviserId, PageParam pageParam);

	/**
	 * 获取图书关联统计个数(商品，应用，资源)
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @param adviserId
	 *            编辑标识
	 * @return
	 */
	BookAssocCount getCount4BookAssoc(Long bookId, Long channelId, Long adviserId);

	/**
	 * 导出出版下所有书刊excel表（出版端）
	 * 
	 * @param agentId
	 *            出版标识
	 */
	void exportBookToExcel(Long agentId);

	/**
	 * 根据isbn获取图书信息
	 * 
	 * @param isbn
	 * @return
	 */
	Map<Long, BookDto> listByIsbn(String isbn);

	/**
	 * 图书列表（平台端）
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param paramMap
	 * @return
	 */
	PageBean listBookClassify(PageParam pageParam, Map<String, Object> paramMap);


	/**
	 * 导出图书列表（平台端）
	 * @param paramMap
	 */
	void exportBookClassify(Map<String, Object> paramMap);

	/**
	 * 导出平台下所有书刊excel表（平台端）
	 */
	void exportBookToExcel4Platform();

	/**
	 * 获取图书基本信息（编辑 - 运营 - 图书）
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @param channelId
	 *            运营标识
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookDto getBookById(Long adviserId, Long channelId, Long bookId);

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param typeCode
	 * @return
	 * @throws BizException
	 */
	BookDto getByIsbnAndTypeCode(String isbn, String typeCode) throws BizException;
	
	/**
	 * 编辑新增图书
	 * @param book
	 *            图书基本信息
	 * @return
	 */
	BookDto create4Adviser(Book book);

	/**
	 * 修改图书类型与图书基本信息
	 * @param book
	 */
	void updateBookAndBookType(Book book);
	/**
	 * 校验书籍isbn码
	 * @param isbn
	 * @return
	 */
	Boolean checkISBN4App(String isbn);
	/**
	 * @param partyId	编辑ID
	 * @param channelId	渠道ID
	 * @param pageParam	分页参数
	 * @return
	 * @throws BizException
	 */
	PageBean getBookBaseInfoListByChannelId4Adviser(Long partyId,Long channelId,PageParam pageParam, String name) throws BizException;

	/**
	 * 修改时间
	 * @param bookId
	 * @throws BizException
	 */
	void updateTimeById(Long bookId)throws BizException;

	/**
	 * 根据ID批量修改时间
	 * @param bookAdviserUpdateTimeDTO
	 * @throws BizException
	 */
	void updateTimeByIds(BookAdviserUpdateTimeDTO bookAdviserUpdateTimeDTO)throws BizException;

	/**
	 * 获取书刊信息
	 * @return
	 * @throws BizException
	 */
	Map<String,BookInfoAnalysicsDTO> getBookInfoBy(List<BookInfoAnalysicsDTO> bookInfoAnalysicsDTOS,String monthDate)throws BizException;

	/**
	 * 获取图书分类标识
	 * @param adviserId
	 * @param channelId
	 * @param bookId
	 * @return
	 */
	Long getBookTempletIdId(Long adviserId, Long channelId, Long bookId);

	/**
	 * 获取书刊信息
	 * @param bookIds
	 * @param monthDate
	 * @return
	 * @throws BizException
	 */
	Map<Long,BookInfo4AnlysicsDTO> getBookAnalysis(List<Long> bookIds, String monthDate)throws BizException;

	/**
	 * 获取书刊基本信息
	 * @param pageParam
	 * @param name
	 * @return
	 * @throws BizException
	 */
	PageBean getListPage4PC(PageParam pageParam,String name)throws BizException;

	/**
	 * 获取未设置授权信息图书
	 * @param listNoAuthBookParam
	 * @return
	 */
    PageBeanNew listNoAuthBook(ListNoAuthBookParam listNoAuthBookParam, Long adviserId);

	/**
	 * 获取未设置授权的社群书
	 * @param listNoAuthGroupBookParam
	 * @param adviserId
	 * @return
	 */
	PageBeanNew listNoAuthGroupBook(ListNoAuthGroupBookParam listNoAuthGroupBookParam, Long adviserId);

	/**
	 * 获取图书基本信息与授权状态
	 */
	BookInfoAndAuthStatusDTO getBaseAndAuthStatus(Long bookId, Long channelId, Long adviserId);

	/**
	 * 根据书名或ISBN编号获取书id集合
	 */
	List<Long> getIdsByNameOrISBN(String keyword, Long adviserId);

	/**
	 * 获取1v1社群书书刊列表
	 * @param currentPage
	 * @param numPerPage
	 * @param name
	 * @param adviserId
	 * @return
	 */
    PageBeanNew<AdviserBookInfoDTO> getListPage4SelfBookGroup(Integer currentPage, Integer numPerPage, String name,Long adviserId);

	/**
	 * 获取书籍标签
	 */
    Map<Integer,List<BookLabel>> getBookLabels();


	/**
	 * 书刊收益列表-出版端
	 */
	PageBeanNew<BookSaleVO> listPageIncomeDetail(PageParam pageParam, Map<String, Object> paramMap, Long agentId);

	/**
	 * 导出书刊收益--出版端
	 */
	void exportBookIncomeDetail(Map<String, Object> paramMap, Long agentId, Long partyId, String systemCode);

}
