package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dao.BookAuthServeDao;
import com.pcloud.book.copyright.dto.ServeDTO;
import com.pcloud.book.copyright.entity.BookAuthServe;
import com.pcloud.book.copyright.vo.ServeVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/3 14:18
 */
@Component("bookAuthServeDao")
public class BookAuthServeDaoImpl extends BaseDaoImpl<BookAuthServe> implements BookAuthServeDao {
    @Override
    public void deleteServes(List<Long> ids){
        this.getSqlSession().update(this.getStatement("deleteServes"), ids);
    }

    @Override
    public List<ServeDTO> isSetServeAuth(Long bookId, Long channelId, Long adviserId, List<Long> serveIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("serveIds", serveIds);
        return this.getSqlSession().selectList(this.getStatement("isSetServeAuth"), paramMap);
    }

    @Override
    public List<ServeVO> listServesByBook(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return this.getSqlSession().selectList(this.getStatement("listServesByBook"), paramMap);
    }

    @Override
    public Boolean checkIsNeedAuth(Long bookId, Long channelId, Long adviserId, Long serveId, String serveType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("serveId", serveId);
        paramMap.put("serveType", serveType);
        return  this.getSqlSession().selectOne(this.getStatement("checkIsNeedAuth"), paramMap);
    }

    @Override
    public List<Long> selectNeedDelete(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return this.getSqlSession().selectList(this.getStatement("selectNeedDelete"), paramMap);
    }
}
