package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.GroupAndUserNumberDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfo4Advertising;
import com.pcloud.book.group.dto.GroupQrcodeInfoDTO;
import com.pcloud.book.group.dto.GroupQrcodeServerDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.GroupQrcodeBookVO;
import com.pcloud.book.group.vo.ListGroupQrcodeResponseVO;
import com.pcloud.book.group.vo.ListQrcodeByClassifyParamVO;
import com.pcloud.book.group.vo.UpdateGroupQrcodeRequestVO;
import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/18 15:30
 */
public interface GroupQrcodeBiz {

    /**
     * 根据Server获取相关的群id
     * @param serverId
     * @return
     */
    List<GroupQrcodeServerDTO> getWxGroupIdByServerId(List<Long> serverIds);
    /**
     * 更新群人数
     */
    Integer updateGroupCount(String wxGroupId, Integer num);
    /**
     * 查询是否需要切群，若需要则返回新群，不需要则为空前端展示客服二维码
     */
    String getChangeGroupQrCode(Long classifyId);

    /**
     * 测试替换群二维码，不发生产
     */
    void updateGroupQrcode(UpdateGroupQrcodeRequestVO vo);

    /**
     * 测试替换群二维码，不发生产
     * @param wxGroupName
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<ListGroupQrcodeResponseVO> listAllGroupQrcode(String wxGroupName, Integer currentPage, Integer numPerPage);
    /**
     * @Author:lili
     * @Desr:新增微信群二维码
     * @Date:2019/4/17 17:44
     */
    Long insert(GroupQrcode groupQrcode);

    /**
     * @Author:lili
     * @Desr:根据分类删除微信群
     * @Date:2019/4/18 11:55
     */
    void deleteByClassifyId(Long classifyId);

    /**
     * @Author:lili
     * @Desr:批量获取群数量与群总人数
     * @Date:2019/4/18 20:08
     */
    Map<Long, GroupAndUserNumberDTO> listGroupAndUserNumber(List<Long> classifyIds);


    /**
     * @Author:lili
     * @Desr:获取分类下二维码
     * @Date:2019/4/17 15:53
     */
    PageBeanNew<ClassifyQrcodeVO> listQrcodeByClassify(ListQrcodeByClassifyParamVO listQrcodeByClassifyParamVO);

    /**
    * @description 获取社群码类别下的群---不分页
    * @author 戴兴
    * @date 2019/7/28 15:59
    */
    List<ClassifyQrcodeVO> getQrcodeByClassify(Long bookGroupId, Long classifyId);

    /**
     * @Author:lili
     * @Desr:修改微信群名称
     * @Date:2019/4/1 11:22
     */
    void modifyWechatGroupName(String wechatGroupName, Long id, Long updateUser);

    /**
     * @Author:lili
     * @Desr:新增一个用户
     * @Date:2019/4/28 14:45
     */
    void addOneUser(String wechatGroupId, Integer memberCount, String nickName, String robotId, String ip);

    /**
     * @Author:lili
     * @Desr:获取群二维码相关信息
     * @Date:2019/4/29 14:46
     */
    Map<Long,GroupQrcodeInfoDTO> listQrcodeInfoByIds(List<Long> groupQrcodeIds);

    /**
     * @Author:lili
     * @Desr:获取群基本信息
     * @Date:2019/5/6 16:12
     */
    GroupQrcodeBaseInfoVO getBaseById(Long groupQrcodeId);

    /**
     * @Author:lili
     * @Desr:更新用户数
     * @Date:2019/5/28 11:47
     */
    void updateUserNumber(String weixinGroupId, String wxUserId);

    /**
     * 群信息及广告信息
     * @param wxGroupIds
     * @return
     */
    Map<String, GroupQrcodeInfo4Advertising> listGroupQrcodeInfo4Advertising(List<String> wxGroupIds);

    /**
     * 将二维码改为已满群
     * @param weixinQrcodeId
     * @param groupQrcodeId
     */
    void changeToOverNumber(Long weixinQrcodeId, Long groupQrcodeId);

    /**
     * 将二维码改为未满群
     * @param weixinQrcodeId
     * @param groupQrcodeId
     */
    void changeToNotOverNumber(Long weixinQrcodeId, Long groupQrcodeId);

    /**
     * 按条件查微信群
     * @param query
     * @param proLabelId
     * @param depLabelId
     * @param purLabelId
     * @return
     */
    List<Long> listQrcodeIdsByLabelQuery(String query, Long proLabelId, Long depLabelId, Long purLabelId);

    /**
     * 过滤删除的群二维码id
     * @param wxGroupIdList
     * @return
     */
    List<Long> filterDeleteId(List<String> wxGroupIdList);

    /**
     * 获取编辑下二维码
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param adviserId
     * @return
     */
    PageBeanNew<GroupQrcodeBookVO> listQrcodeByAdviser(Integer currentPage, Integer numPerPage, String name, Long adviserId);

    /**
     * 猜谜语列表
     * @param partyId
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<GroupRiddleDTO> listPageRiddle(Long partyId, Integer currentPage, Integer numPerPage, String name);

    /**
    * @description 获取微信群信息
    * @author 戴兴
    * @date 2019/9/20 16:36
    */
    GroupQrcodeInfo4Advertising getWechatGroupInfo(Long qrcodeId);

    /**
    * @description 批量获取微信群信息
    * @author 戴兴
    * @date 2019/9/21 19:10
    */
    Map<Long, GroupQrcodeInfo4Advertising> getWechatGroupInfoMap(List<Long> qrcodeIds);

    /**
     * 平台端查群列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<GroupQrcodeBookVO> listQrcodeByPcloud(Integer currentPage, Integer numPerPage, String name, Long depLabelId);

    /**
     * 切群之后要做的事
     */
    void dealAfterChangeANewGroup(WeixinQrcodeDTO oneQrcode, Long classifyId);

    /**
     * 根据类型获取当前群总人数
     */
    Integer getUserCountByJoinGroupType(Integer joinGroupType);
}
