package com.pcloud.book.group.biz.impl;

import com.pcloud.book.group.biz.CopyCipherRecordBiz;
import com.pcloud.book.group.dao.CopyCipherRecordDao;
import com.pcloud.book.group.entity.CopyCipherRecord;
import com.pcloud.common.core.aspect.ParamLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/15 14:15
 **/
@Component("copyCipherRecordBiz")
public class CopyCipherRecordBizImpl implements CopyCipherRecordBiz {

    @Autowired
    private CopyCipherRecordDao copyCipherRecordDao;

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("新增复制暗号记录")
    @Override
    public Long createCopyCipherRecord(CopyCipherRecord copyCipherRecord) {
        copyCipherRecordDao.insert(copyCipherRecord);
        return copyCipherRecord.getId();
    }
}
