package com.pcloud.book.keywords.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/30 10:55
 **/
@Data
@ApiModel("个人号关键词")
public class SelfRobotKeyword extends BaseEntity {

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("延时时间")
    private Integer delayTime;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("关键词回复列表")
    private List<SelfRobotKeywordReply> keywordReplyList;
}
