package com.pcloud.book.keywords.facade.impl;

import com.pcloud.book.keywords.biz.SelfRobotKeywordBiz;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.book.keywords.facade.SelfRobotKeywordFacade;
import com.pcloud.book.keywords.vo.LabelVO;
import com.pcloud.book.keywords.vo.SelfRobotReplyVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/30 11:05
 **/
@RestController("selfRobotKeywordFacade")
@RequestMapping("selfRobotKeyword")
public class SelfRobotKeywordFacadeImpl implements SelfRobotKeywordFacade {

    @Autowired
    private SelfRobotKeywordBiz selfRobotKeywordBiz;

    @ApiOperation("批量新增个人号关键词")
    @PostMapping("batchAddSelfRobotKeyword")
    @Override
    public ResponseDto<?> batchAddSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") List<SelfRobotKeyword> selfRobotKeywords
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        selfRobotKeywordBiz.batchAddSelfRobotKeyword(partyId, selfRobotKeywords);
        return new ResponseDto<>();
    }

    @ApiOperation("更新个人号关键词")
    @PostMapping("updateSelfRobotKeyword")
    @Override
    public ResponseDto<?> updateSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        selfRobotKeywordBiz.updateSelfRobotKeyword(partyId, selfRobotKeyword);
        return new ResponseDto<>();
    }

    @ApiOperation("删除个人号关键词")
    @GetMapping("deleteSelfRobotKeyword")
    @Override
    public ResponseDto<?> deleteSelfRobotKeyword(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("个人号关键词id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        selfRobotKeywordBiz.deleteSelfRobotKeyword(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList")
    @Override
    public ResponseDto<?> getSelfRobotKeywordList(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(selfRobotKeywordBiz.getSelfRobotKeywordList(bookGroupId,keyword,currentPage,numPerPage));
    }

    @ApiOperation("客户端获取个人号关键词列表")
    @GetMapping("getSelfRobotKeywordList4Wechat")
    @Override
    public ResponseDto<?> getSelfRobotKeywordList4Wechat(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam(value = "keyword",required = false) @ApiParam("关键词") String keyword,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException {
        Cookie.getUserInfo(userInfo);
        return new ResponseDto<>(selfRobotKeywordBiz.getSelfRobotKeywordList(bookGroupId,keyword,currentPage,numPerPage));
    }

    @ApiOperation("修改个人号关键词排序值")
    @PostMapping("updateSelfRobotKeywordSeqNum")
    @Override
    public ResponseDto<?> updateSelfRobotKeywordSeqNum(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("个人号关键词") SelfRobotKeyword selfRobotKeyword
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        selfRobotKeywordBiz.updateSelfRobotKeywordSeqNum(selfRobotKeyword);
        return new ResponseDto<>();
    }

    @ApiOperation("获取应用或作品链接")
    @GetMapping("getAppOrProductServeUrl")
    @Override
    public ResponseDto<?> getAppOrProductServeUrl(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam("serveId") @ApiParam("作品或应用id") Long serveId,
            @RequestParam("serveType") @ApiParam("作品或应用类型") String serveType,
            @RequestParam("serveUrl") @ApiParam("作品或应用链接") String serveUrl
    ) throws BizException, PermissionException {
        Cookie.getUserInfo(userInfo);
        return new ResponseDto<>(selfRobotKeywordBiz.getAppOrProductServeUrl(bookGroupId,serveId,serveType,serveUrl));
    }

    @Override
    @GetMapping("getGuideWordListByType")
    public ResponseDto<?> getGuideWordListByType(@RequestParam("type") Integer type) throws BizException, PermissionException {
        return new ResponseDto<>(selfRobotKeywordBiz.getGuideWordListByType(type));
    }

    @Override
    @GetMapping("listLabelByType")
    public ResponseDto<?> listLabelByType(@RequestParam("type") Integer type) throws BizException, PermissionException {
        List<LabelVO> list = selfRobotKeywordBiz.listLabelByType(type);
        return new ResponseDto<>(list);
    }

    @Override
    @GetMapping("getReplyByLabel")
    public ResponseDto<?> getReplyByLabel(@RequestParam("type") Integer type, @RequestParam Long labelId,@RequestParam String robotId, @RequestParam String wxUserId) throws BizException, PermissionException {
        List<SelfRobotReplyVO> list = selfRobotKeywordBiz.getReplyByLabel(type, labelId, robotId, wxUserId);
        return new ResponseDto<>(list);
    }

    @Override
    @GetMapping("getReplyByKeyWord")
    public ResponseDto<?> getReplyByKeyWord(@RequestParam("keyWord") String keyWord,
                                            @RequestParam("type") Integer type,
                                            @RequestParam("robotId") String robotId,
                                            @RequestParam("wxUserId") String wxUserId) throws BizException, PermissionException {
        List<SelfRobotReplyVO> list = selfRobotKeywordBiz.getReplyByKeyWord(type, keyWord, robotId, wxUserId);
        return new ResponseDto<>(list);
    }

    @Override
    @GetMapping("getReplyByGuide")
    public ResponseDto<?> getReplyByGuide(@RequestParam Integer type, @RequestParam Integer id, @RequestParam String robotId, @RequestParam String wxUserId) {
        List<SelfRobotReplyVO> list = selfRobotKeywordBiz.getReplyBuyGuide(type, id, robotId, wxUserId);
        return new ResponseDto<>(list);
    }

    @Override
    @GetMapping("getResource")
    public ResponseDto<?> getResource(@RequestParam Integer id, @RequestParam String robotId, @RequestParam String wxUserId) {

        return new ResponseDto<>(selfRobotKeywordBiz.getResource(id, robotId, wxUserId));
    }

    @Override
    @GetMapping("joinGroup")
    public ResponseDto<?> joinGroup(@RequestParam Integer id, @RequestParam String robotId, @RequestParam String wxUserId) {

        return new ResponseDto<>(selfRobotKeywordBiz.joinGroup(id, robotId, wxUserId));
    }

    @Override
    @GetMapping("sendWhenNoReply")
    public ResponseDto<?> sendWhenNoReply(@RequestParam Integer id, @RequestParam String robotId, @RequestParam String wxUserId) {
        selfRobotKeywordBiz.sendWhenNoReply(id, robotId, wxUserId);
        return new ResponseDto<>();
    }

}
