package com.pcloud.book.pcloudKeyword.service;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "robotServiceCloud", path = "book/v1.0/pcloudRobotService")
@Api(description = "平台个人号内部接口")
public interface PcloudRobotService {

    @ApiOperation(value = "批量获取个人号分类信息", httpMethod = "POST")
    @PostMapping("getRobotClassifyBatch")
    ResponseEntity<ResponseDto<Map<String, RobotClassifyDTO>>> getRobotClassifyBatch(@RequestBody List<String> robotIds);


    @ApiOperation(value = "获取所有个人号分类信息", httpMethod = "GET")
    @GetMapping("getAllPcloudRobot")
    ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobot();

}
