package com.pcloud.book.timecontrol.dto;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @date: 2020年01月30日 18:24
 * @Author: Zcy
 * @Descprition 任务配置
 */
@Data
public class CreateTaskItemDto implements Serializable {

    @NotNull(message = "任务ID不能为空")
    private Integer taskId;
    @NotNull(message = "请输入天数")
    @Max(value = 200)
    private Integer startDay;

    private Integer finishConfirm;

    private String finishKeyWord;

    List<CreateReplyMessageDto> replyMessageList;

    private Integer tdConfirm;

    private String finishLinkIntroduce;

    private String finishLinkUrl;

    List<CreateReplyMessageDto> completedReplyMessageList;

    private Integer addSendTime;

    @NotNull(message = "发送时间设置不能为空")
    private String sendHour;

}
