/**
 * 
 */
package com.pcloud.book.book.dao;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.entity.BookResource;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：书籍资源数据访问层接口
 * @作者：lili
 * @创建时间：2017年3月17日,下午3:56:09 @版本：1.0
 */
public interface BookResourceDao extends BaseDao<BookResource> {

	/**
	 * 删除资源关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	public long deleteByBook(Long bookId);

	/**
	 * 批量删除资源关联关系
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	public long deleteByBooks(List<Long> bookIds);

	/**
	 * 获取书籍关联的资源
	 * 
	 * @param bookResource
	 *            图书资源关联实体
	 * @return
	 */
	public List<BookResourceDto> getListById(BookResource bookResource);

	/**
	 * 根据书籍和渠道删除书籍资源关联信息
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap);

	/**
	 * 根据图书资源标识获取图书资源关联
	 * 
	 * @param bookResourceId
	 *            图书资源关联标识
	 * @return
	 */
	public BookResourceDto getByBookResourceId(Long bookResourceId);

	/**
	 * 根据资源标识获取关联图书
	 * 
	 * @param resourceId
	 *            资源标识
	 * @return
	 */
	public List<BookResourceDto> listBookByResource(Long resourceId);

	/**
	 * 获取图书关联资源个数
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer getResourceCount(Map<String, Object> paramMap);

	/**
	 * 获取资源关联的图书
	 * 
	 * @param resourceId
	 *            资源标识
	 * @return
	 */
	public List<Long> listByResourceId(Long resourceId);

}
