package com.pcloud.book.pcloudkeyword.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.wechatgroup.base.dto.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;
@Data
@ApiModel("全平台关键词分类")
public class PcloudKeywordClassifyDTO extends BaseDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("分类")
    private String keywordClassify;

    @ApiModelProperty("是否启用")
    private Boolean open;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

}
