package com.pcloud.book.push.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("个人号群发用户")
@Data
public class SelfPushUser extends BaseEntity{

    @ApiModelProperty("群发id")
    private Long pushId;

    @ApiModelProperty("微信用户id")
    private String wxUserId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

}