package com.pcloud.book.advertising.dao;

import java.util.List;
import com.pcloud.book.advertising.entity.AdvertisingDistributionBook;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告位投放书籍数据访问层接口
 * @author PENG
 * @date 2019/2/28
 */
public interface AdvertisingDistributionBookDao extends BaseDao<AdvertisingDistributionBook> {

    /**
     * 批量新增
     * @param list 列表
     * @return
     */
    long batchInsert(List<AdvertisingDistributionBook> list);

    /**
     * 校验书刊是否已投放
     * @param list 列表
     * @return
     */
    List<Long> checkBookIdExist(List<Long> list);

    /**
     * 获取广告位投放的书刊列表
     * @param adId 广告位ID
     * @return
     */
    List<AdvertisingDistributionBook> getByAdId(Long adId);
}
