package com.pcloud.book.advertising.dao.impl;

import java.util.List;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingDistributionBookDao;
import com.pcloud.book.advertising.entity.AdvertisingDistributionBook;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位投放书籍数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingDistributionBookDao")
public class AdvertisingDistributionBookDaoImpl extends BaseDaoImpl<AdvertisingDistributionBook> implements AdvertisingDistributionBookDao {

    /**
     * 批量新增
     */
    @Override
    public long batchInsert(List<AdvertisingDistributionBook> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    /**
     * 校验书刊是否已投放
     */
    @Override
    public List<Long> checkBookIdExist(List<Long> list) {
        return super.getSqlSession().selectList(getStatement("checkBookIdExist"), list);
    }

    /**
     * 获取广告位投放的书刊列表
     */
    @Override
    public List<AdvertisingDistributionBook> getByAdId(Long adId) {
        return super.getSqlSession().selectList(getStatement("getByAdId"), adId);
    }
}
