package com.pcloud.book.advertising.enums;

/**
 * Description 广告位置枚举
 * @author PENG
 * @date 2019/3/1
 */
public enum AdPositionEnum {

    /**
     * 应用或作品详情浮标
     */
    DETAIL_PAGE("DETAIL_PAGE", "应用或作品详情浮标", true),

    /**
     * 扫码消息
     */
    SCENE_MESSAGE("SCENE_MESSAGE", "扫码消息", false);

    public final String positionCode;
    public final String positionName;
    public final Boolean isOpen;

    AdPositionEnum(String positionCode, String positionName, Boolean isOpen) {
        this.positionCode = positionCode;
        this.positionName = positionName;
        this.isOpen = isOpen;
    }

    /**
     * 校验位置是否存在
     */
    public static Boolean checkCodeExist(String positionCode) {
        AdPositionEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionEnum adPositionEnum = var1[var3];
            if (adPositionEnum.positionCode.equals(positionCode) && adPositionEnum.isOpen) {
                return true;
            }
        }
        return false;
    }

    public static final String[] AD_POSITION_GATHER = {DETAIL_PAGE.positionCode, SCENE_MESSAGE.positionCode};
}
