/**
 * 
 */
package com.pcloud.book.book.dao.impl;

import com.google.common.collect.Maps;
import com.pcloud.book.book.dao.BookAdviserDao;
import com.pcloud.book.book.dto.*;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：编辑管理书籍数据访问层接口实现类
 * @作者：songx
 * @创建时间：2016年12月30日,下午5:15:37 @版本：1.0
 */
@Repository("bookAdviserDao")
public class BookAdviserDaoImpl extends BaseDaoImpl<BookAdviser> implements BookAdviserDao {

	/**
	 * 删除编辑和书籍的推广信息
	 */
	@Override
	public long deleteByBook(Long bookId) {
		return super.getSqlSession().update(super.getStatement("deleteByBook"), bookId);
	}

	/**
	 * 批量删除编辑和书籍的推广信息
	 */
	@Override
	public long deleteByBooks(List<Long> bookIds) {
		return super.getSqlSession().delete(super.getStatement("deleteByBooks"), bookIds);
	}

	/**
	 * 获取编辑设置的书籍推广信息
	 */
	@Override
	public BookAdviserDto getByAdviser(BookAdviser bookAdviser) {
		return super.getSqlSession().selectOne(super.getStatement("getByAdviser"), bookAdviser);
	}

	/**
	 * 统计编辑推广的图书总数
	 */
	@Override
	public Map<Long, BookAdviserDto> getCountByAdvisers(List<Long> adviserIds) {
		return super.getSqlSession().selectMap(super.getStatement("getCountByAdvisers"), adviserIds, "adviserId");
	}

	/**
	 * 根据ISBN获取图书信息
	 */
	@Override
	public BookAdviserDto getByIsbn(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getByIsbn"), paramMap);
	}

	/**
	 * 获取配置过书籍的编辑top1
	 */
	@Override
	public Long getAdviserTop1(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getAdviserTop1"), paramMap);

	}

	/**
	 * 根据书籍和渠道删除书籍编辑关联信息
	 */
	@Override
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap) {

		return super.getSqlSession().update(super.getStatement("deleteByBookAndChannel"), paramMap);

	}

	/**
	 * 根据图书信息获取主编辑ID
	 */
	@Override
	public Long getMainAdviserId(Long bookId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId", bookId);
		paramMap.put("channelId", channelId);
		return super.getSqlSession().selectOne(super.getStatement("getMainAdviserId"), paramMap);
	}

	/**
	 * 根据bookId获取编辑信息
	 */
	@Override
	public List<AdviserManageDto> getAdviserList(Long bookId) {

		return super.getSqlSession().selectList(this.getStatement("getAdviserList"), bookId);
	}

	/**
	 * 根据bookId获取编辑ID
	 */
	@Override
	public List<Long> getAdviserIdsByBookId(Long bookId) {

		return super.getSqlSession().selectList(this.getStatement("getAdviserIdsByBookId"), bookId);
	}

	/**
	 * 编辑管理--删除副编辑
	 */
	@Override
	public Integer delViceAdviser(List<BookAdviser> bookAdvisers) {

		return super.getSqlSession().delete(super.getStatement("delViceAdviser"), bookAdvisers);
	}

	/**
	 * 获取在某个运营平台关联过某本书的所有编辑的ID（未删除的）
	 */
	@Override
	public List<Long> getAdviserIdsByBookAndChannel(Long bookId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId", bookId);
		paramMap.put("channelId", channelId);
		return super.getSqlSession().selectList(this.getStatement("getAdviserIdsByBookAndChannel"), paramMap);
	}

	/**
	 * 根据bookIds查询书刊编辑关联信息
	 */
	@Override
	public Map<Long, BookAdviserDto> getByBookIds(List<Long> bookIds) {
		return super.getSqlSession().selectMap(this.getStatement("getByBookIds"), bookIds, "bookId");
	}

	/**
	 * 编辑下的所有书刊的数目
	 */
	@Override
	public Integer getBookCount(List<Long> adviserIds) {
		return super.getSqlSession().selectOne(this.getStatement("getBookCount"), adviserIds);
	}

	/**
	 * 更新图书模板信息
	 */
	@Override
	public void updateBookTemplet(BookAdviser bookAdviser) {
		super.getSqlSession().update(this.getStatement("updateBookTemplet"), bookAdviser);
	}

	/**
	 * 每日新增书刊数-出版
	 */
	@Override
	public List<BookCountDto> listBookCountByDate4Agent(Map<String, Object> paramMap) {
		return super.getSqlSession().selectList(this.getStatement("listBookCountByDate4Agent"), paramMap);
	}

	/**
	 * 删除书籍（编辑端）
	 */
	@Override
	public void updateBook4Adviser(Map<String, Object> paramMap) {
		super.getSqlSession().update(this.getStatement("updateBook4Adviser"), paramMap);
	}

	/**
	 * 该书是否是主编辑
	 */
	@Override
	public Boolean isMainAdviser4Book(Map<String, Long> paramMap) {
		return super.getSqlSession().selectOne(this.getStatement("isMainAdviser4Book"), paramMap);
	}

	/**
	 * 获取编辑设置的书籍推广信息(包含删除或未删除的)
	 */
	@Override
	public BookAdviserDto getByAdviserContainsDelete(BookAdviser bookAdviser) {
		return super.getSqlSession().selectOne(super.getStatement("getByAdviserContainsDelete"), bookAdviser);
	}

	/**
	 * 获取编辑的图书总数
	 */
	@Override
	public Integer getAdviserBookCount(Long adviserId) {
		return super.getSqlSession().selectOne(super.getStatement("getAdviserBookCount"), adviserId);
	}

	/**
	 * 获取被诉方信息(即与该书关联的所有编辑)
	 */
	@Override
	public List<BookAdviserDto> getAdvisers(Long bookId) {
		return super.getSqlSession().selectList(super.getStatement("getAdvisers"), bookId);
	}

	/**
	 * 获取该书被多少主编辑推广过
	 * @param bookId 图书标识
	 * @return
	 */
	@Override
	public Integer getCount4BookAdviser(Long bookId) {
		return super.getSqlSession().selectOne(this.getStatement("getCount4BookAdviser"), bookId);
	}

	@Override
	public BookAdviserDto getBase(Long bookId, Long channelId, Long adviserId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		return super.getSqlSession().selectOne(this.getStatement("getBase"), paramMap);
	}
    @Override
    public List<AdviserBookInfoDTO> listAdviserBookInfo(AviserBookInfoParam aviserBookInfoParam) {
		return super.getSqlSession().selectList(this.getStatement("listAdviserBookInfo"), aviserBookInfoParam);
    }

	@Override
	public Map<Long, BookCountAndAdviserIdDTO> getBookCountByAdviserId(BookCountByAdvisersDto bookCountByAdvisersDto) {
		return super.getSqlSession().selectMap(this.getStatement("getBookCountByAdviserId"),bookCountByAdvisersDto,"adviserId");
	}

	@Override
	public int updateBookBySecondTempletId(Long parentId,Long originTempletId, Long secondTempletId) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("parentId",parentId);
		map.put("originTempletId",originTempletId);
		map.put("secondTempletId",secondTempletId);
		return getSqlSession().update(getStatement("updateBookBySecondTempletId"),map);
	}
}
