package com.pcloud.book.consumer.wechatgroup;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.resource.ProductConsr;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.wechatgroup.group.dto.GroupMemberStatisDTO;
import com.pcloud.wechatgroup.group.dto.GroupRobotDTO;
import com.pcloud.wechatgroup.group.dto.RobotReplyDTO;
import com.pcloud.wechatgroup.group.service.GroupMemberService;
import com.pcloud.wechatgroup.message.dto.GroupChatCountDTO;
import com.pcloud.wechatgroup.message.service.MessageService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component("wechatGroupConsr")
public class WechatGroupConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductConsr.class);


    @Autowired
    private GroupMemberService groupMemberService;

    @Autowired
    private MessageService messageService;

    /**
     * 根据群号获取机器人微信号
     */
    public String getRobotIdByGroupId(String groupId) throws BizException {
        LOGGER.info("【根据群号获取机器人微信号,<START>.[groupId]=" + groupId + "]");
        if (groupId == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseResponse(groupMemberService.getRobotIdByGroupId(groupId), String.class);
        } catch (BizException e) {
            LOGGER.warn("根据群号获取机器人微信号失败:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            LOGGER.error("根据群号获取机器人微信号.[getRobotIdByGroupId]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
        } finally {
            LOGGER.info("【根据群号获取机器人微信号,<END>");
        }
    }

    @ParamLog(value = "累计进群人数与今日进群人数", isBefore = false, isAfterReturn = false)
    public Map<String, GroupMemberStatisDTO> listGroupMemberStatisInfo(List<String> weixinGroupIds) throws BizException {
        if (ListUtils.isEmpty(weixinGroupIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapGroupMemberStatisInfo(weixinGroupIds), String.class, GroupMemberStatisDTO.class);
        } catch (Exception e) {
            LOGGER.error("获取累计进群人数与今日进群人数.[listGroupMemberStatisInfo]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "活跃人数与总发言数", isBefore = false, isAfterReturn = false)
    public Map<Long, GroupChatCountDTO> getChatCountByGroup(List<Long> groupQrcodeIds, Long bookGroupId) throws BizException {
        if (ListUtils.isEmpty(groupQrcodeIds) || bookGroupId == null) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(messageService.getChatCountByGroup(groupQrcodeIds, bookGroupId), Long.class, GroupChatCountDTO.class);
        } catch (Exception e) {
            LOGGER.error("获取活跃人数与总发言数.[getChatCountByGroup]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "获取退群率", isBefore = false, isAfterReturn = false)
    public Map<String, BigDecimal> mapOutGroupRate(List<String> wxGroupIds) throws BizException {
        if (ListUtils.isEmpty(wxGroupIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(groupMemberService.mapOutGroupRate(wxGroupIds), String.class, BigDecimal.class);
        } catch (Exception e) {
            LOGGER.error("获取退群率失败.[mapOutGroupRate]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "上传群二维码时根据群ID添加群管理员（群主，机器人等）")
    public void addGroupManagers(String wxGroupId, String altId) throws BizException {
        try {
            groupMemberService.addGroupManagers(wxGroupId, altId);
        } catch (Exception e) {
            LOGGER.error("上传群二维码时根据群ID添加群管理员（群主，机器人等）失败.[addGroupManagers]:" + e.getMessage(), e);
        }
    }

    @ParamLog(value = "获取所有机器人微信号")
    public List<String> listAllRobotWxId() throws BizException {
        try {
            List<String> wxids = ResponseHandleUtil.parseListResponse(groupMemberService.listAllRobotWxId(), String.class);
            return wxids;
        } catch (Exception e) {
            LOGGER.error("获取所有机器人微信号失败.[listAllRobotWxId]:" + e.getMessage(), e);
        }
        return null;
    }

    @ParamLog(value = "设置第一个关键词回复")
    public void addFirstRobotReplyRecord(RobotReplyDTO robotReplyDTO) throws BizException {
        try {
            groupMemberService.addFirstRobotReplyRecord(robotReplyDTO);
        } catch (Exception e) {
            LOGGER.error("设置第一个关键词回复失败.[addFirstRobotReplyRecord]:" + e.getMessage(), e);
        }
    }

    @ParamLog(value = "获取机器人信息")
    public GroupRobotDTO getRobotInfoByWxUserId(String wxRobotId) throws BizException {
        try {
            return ResponseHandleUtil.parseResponse(groupMemberService.getRobotInfoByWxUserId(wxRobotId), GroupRobotDTO.class);
        } catch (Exception e) {
            LOGGER.error("获取机器人信息失败.[getRobotInfoByWxUserId]:" + e.getMessage(), e);
        }
        return null;
    }
}
