package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dao.BookAuthCodeDao;
import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:32
 */
@Component("bookAuthCodeDao")
public class BookAuthCodeDaoImpl extends BaseDaoImpl<BookAuthCode> implements BookAuthCodeDao {

    @Override
    public Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        return this.getSqlSession().selectOne(this.getStatement("getMaxBatchNum"), paramMap);
    }

    @Override
    public Integer updateUseCount(Long bookId, Long channelId, Long adviserId, String code, Integer codeUseCount) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("codeUseCount",codeUseCount);
        paramMap.put("code",code);
        return this.getSqlSession().update(this.getStatement("updateUseCount"), paramMap);
    }

    @Override
    public Boolean getIsHaveCode(Long bookId, Long channelId, Long adviserId, String code) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("code",code);
        return this.getSqlSession().selectOne(this.getStatement("getIsHaveCode"), paramMap);
    }
}
