package com.pcloud.book.group.biz;

import java.util.List;
import java.util.Map;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

/**
 * Description 社群书群二维码业务逻辑层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupBiz {

    /**
     * 创建社群书时生成群二维码
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    BookGroup createBookGroupAfterCreateBook(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo(Long bookGroupId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo4Wechat(Long bookGroupId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfoByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 更新群二维码信息
     * @param bookGroup 群二维码实体
     * @throws BizException
     */
    void updateBookGroup(BookGroup bookGroup) throws BizException;

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void deleteByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void recoverByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据社群码ID获取书名
     * @param bookGroupId 社群码ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getBookNameByBookGroupId(Long bookGroupId) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBookGroup4Adviser(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @return
     * @throws BizException
     */
    List<BookDto> listSimpleBookGroup4Adviser(Map<String, Object> paramMap) throws BizException;

    /**
     * 获取未创建社群码的书刊列表
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBook4CreateBookGroup(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取群二维码名称以及商品id
     * @Date:2019/4/18 9:57
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取排序方式
     * @Date:2019/4/19 14:57
     */
    Integer getRankType(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:更新排序方式
     * @Date:2019/4/19 14:58
     */
    void updateRankType(Long bookGroupId, Integer rankType) throws BizException;

    /**
     * 编辑获取社群码总数量
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getTotalBookGroupCount(Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:09
     */
    String getSpareQr(Long bookGroupId);
}
