package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.GroupAndUserNumberDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfoDTO;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.ListQrcodeByClassifyParamVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/18 15:30
 */
public interface GroupQrcodeBiz {

    /**
     * @Author:lili
     * @Desr:新增微信群二维码
     * @Date:2019/4/17 17:44
     */
    Long insert(GroupQrcode groupQrcode);

    /**
     * @Author:lili
     * @Desr:根据分类删除微信群
     * @Date:2019/4/18 11:55
     */
    void deleteByClassifyId(Long classifyId);

    /**
     * @Author:lili
     * @Desr:批量获取群数量与群总人数
     * @Date:2019/4/18 20:08
     */
    Map<Long, GroupAndUserNumberDTO> listGroupAndUserNumber(List<Long> classifyIds);


    /**
     * @Author:lili
     * @Desr:获取分类下二维码
     * @Date:2019/4/17 15:53
     */
    PageBeanNew<ClassifyQrcodeVO> listQrcodeByClassify(ListQrcodeByClassifyParamVO listQrcodeByClassifyParamVO);

    /**
     * @Author:lili
     * @Desr:修改微信群名称
     * @Date:2019/4/1 11:22
     */
    void modifyWechatGroupName(String wechatGroupName, Long id, Long updateUser);

    /**
     * @Author:lili
     * @Desr:新增一个用户
     * @Date:2019/4/28 14:45
     */
    void addOneUser(String wechatGroupId, Integer memberCount, String nickName);

    /**
     * @Author:lili
     * @Desr:获取群二维码相关信息
     * @Date:2019/4/29 14:46
     */
    Map<Long,GroupQrcodeInfoDTO> listQrcodeInfoByIds(List<Long> groupQrcodeIds);

    /**
     * @Author:lili
     * @Desr:获取群基本信息
     * @Date:2019/5/6 16:12
     */
    GroupQrcodeBaseInfoVO getBaseById(Long groupQrcodeId);
}
