package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.dto.WeixinQrcodeCountDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.book.group.vo.QrStatisticsVO;
import com.pcloud.book.group.vo.WeixinQrcodeVO;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:10
 */
public interface WeixinQrcodeBiz {

    /**
     * @Author:lili
     * @Desr:从二维码获取一个二维码
     * @Date:2019/4/17 16:17
     */
    WeixinQrcodeDTO getOneQrcode();

    /**
     * @Author:lili
     * @Desr:发送不足100提醒邮件
     * @Date:2019/4/1 11:22
     */
    void sendMsgByQrCount();

    /**
     * @Author:lili
     * @Desr:定时更新二维码
     * @Date:2019/3/12 9:26
     */
    void setUpdateQrUrlByQuartz();

    /**
     * @Author:lili
     * @Desr:发送更新二维码地址请求
     * @Date:2019/3/1 11:38
     */
    void setUpdateQrUrl();

    /**
     * @Author:lili
     * @Desr: 更新二维码地址
     * @Date:2019/3/12 9:27
     */
    void updateQrUrl(UpdateQrDTO updateQrDTO);

    /**
     * @Author:lili
     * @Desr:处理有问题的二维码/或者未处理的二维码
     * @Date:2019/3/12 9:27
     */
    void setUpdateQr4Error(List<Long> ids);

    /**
     * @Author:lili
     * @Desr:发送更新群名称请求
     * @Date:2019/4/2 15:07
     */
    void sendChangeGroupNameRequest(List<Long> ids);

    /**
     * @Author:lili
     * @Desr:同步更新微信群id
     * @Date:2019/4/3 11:07
     */
    void syncWeixinGroupId(Long weixinQrcodeId, String weixinGroupId);

    /**
     * @Author:lili
     * @Desr:发送同步微信id请求
     * @Date:2019/4/15 9:43
     */
    void sendSyncWeixinGroupIdRequest(List<Long> ids);

    /**
     * @Author:lili
     * @Desr:新增二维码
     * @Date:2019/4/26 15:36
     */
    void addQrcode(WeixinQrcodeVO weixinQrcodeVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:获取机器人二维码分配情况
     * @Date:2019/4/26 16:19
     */
    Map<Long,WeixinQrcodeCountDTO> listWeixinQrcodeCountByRobot(List<Long> robotIds);

    /**
     * @Author:lili
     * @Desr:更新使用状态
     * @Date:2019/4/28 17:15
     */
    void updateUseState(Long weixinQrcodeId, Integer useState);

    /**
     * 平台端二维码统计数据
     */
    QrStatisticsVO getQrStatistics();
}
