package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 社群书群二维码数据访问层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupDao extends BaseDao<BookGroup> {

    /**
     * 获取DTO信息
     * @param bookGroupId 群二维码ID
     * @return
     */
    BookGroupDTO getDTOById(Long bookGroupId);

    /**
     * 获取DTO信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long deleteByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long recoverByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 获取编辑社群书数量
     * @param adviserId 编辑ID
     * @return
     */
    Integer getBookGroupCount(Long adviserId);

    /**
     * @Author:lili
     * @Desr:获取群二维码名称与商品标识
     * @Date:2019/4/18 9:58
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取排序类型
     * @Date:2019/4/19 15:01
     */
    Integer getRankType(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:更新排序类型
     * @Date:2019/4/19 15:01
     */
    void updateRankType(Long bookGroupId, Integer rankType);

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:10
     */
    String getSpareQr(Long bookGroupId);
}
