package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

/**
 * @author lily
 * @date 2019/4/17 16:19
 */
public class WeixinQrcode extends BaseEntity {

    /**
     * 二维码ID
     */
    private Long id;

    /**
     * 微信群标识
     */
    private String weixinGroupId;

    /**
     * 机器人标识
     */
    private Long robotId;

    /**
     * 机器人微信账号
     */
    private String robotWxId;

    /**
     * 群地址
     */
    private String qrcodeUrl;

    /**
     *   使用状态0：未使用  1：已使用（人数未满）  2：人数已满
     */
    private Integer useState;

    /**
     *  创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     *  更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     *  更新二维码时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateQrTime;

    /**
     *   更新状态 0 更新成功 1 更新中 2 更新失败 3到期未处理
     */
    private Integer updateState;

    /**
     *   创建人
     */
    private Long createUser;

    /**
     *   更新人
     */
    private Long updateUser;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public Integer getUseState() {
        return useState;
    }

    public void setUseState(Integer useState) {
        this.useState = useState;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateQrTime() {
        return updateQrTime;
    }

    public void setUpdateQrTime(Date updateQrTime) {
        this.updateQrTime = updateQrTime;
    }

    public Integer getUpdateState() {
        return updateState;
    }

    public void setUpdateState(Integer updateState) {
        this.updateState = updateState;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Long getRobotId() {
        return robotId;
    }

    public void setRobotId(Long robotId) {
        this.robotId = robotId;
    }

    public String getRobotWxId() {
        return robotWxId;
    }

    public void setRobotWxId(String robotWxId) {
        this.robotWxId = robotWxId;
    }

    @Override
    public String toString() {
        return "WeixinQrcode{" +
                "id=" + id +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", useState=" + useState +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", updateQrTime=" + updateQrTime +
                ", updateState=" + updateState +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                '}';
    }
}
