package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.facade.BookGroupClassifyFacade;
import com.pcloud.book.group.vo.AddClassifyVO;
import com.pcloud.book.group.vo.BookGroupQrcodeStatisticVO;
import com.pcloud.book.group.vo.ClassifyAndGroupCountVO;
import com.pcloud.book.group.vo.ClassifyAndUserCountVO;
import com.pcloud.book.group.vo.ClassifyNameVO;
import com.pcloud.book.group.vo.ClassifyVO;
import com.pcloud.book.group.vo.GroupQrcode4ClassifyVO;
import com.pcloud.book.group.vo.GroupQrcodeVO;
import com.pcloud.book.group.vo.ListBookGroupQrcodeExportParamVO;
import com.pcloud.book.group.vo.ListBookGroupQrcodeParamVO;
import com.pcloud.book.group.vo.ListClassify4WechatVO;
import com.pcloud.book.group.vo.ListClassifyVO;
import com.pcloud.book.group.vo.ListGroupQrParam;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.group.vo.UpdateClassifyVO;
import com.pcloud.book.group.vo.UpdateRankVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lily
 * @date 2019/4/16 21:02
 */
@RestController("bookGroupClassifyFacade")
@RequestMapping("bookGroupClassify")
public class BookGroupClassifyFacadeImpl implements BookGroupClassifyFacade {

    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;

    @Override
    @GetMapping("listAllClassify")
    public ResponseDto<List<ListClassifyVO>> listAllClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ListClassifyVO> listAllClassifys = bookGroupClassifyBiz.listAllClassify(bookGroupId);
        return new ResponseDto<>(listAllClassifys);
    }

    @Override
    @PostMapping("addClassify")
    public ResponseDto<?> addClassify(@RequestHeader("token") String token, @RequestBody AddClassifyVO addClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.addClassify(addClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassify")
    public ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody UpdateClassifyVO updateClassifyVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassify(updateClassifyVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getClassify")
    public ResponseDto<ClassifyVO> getClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        ClassifyVO classifyVO = bookGroupClassifyBiz.getClassify(classifyId);
        return new ResponseDto<>(classifyVO);
    }

    @Override
    @GetMapping("deleteClassify")
    public ResponseDto<?> deleteClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.deleteClassify(classifyId, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateClassifyRank")
    public ResponseDto<?> updateClassifyRank(@RequestHeader("token") String token, @RequestBody UpdateRankVO updateRankVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.updateClassifyRank(updateRankVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("listClassify")
    public ResponseDto<List<ClassifyNameVO>> listClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        List<ClassifyNameVO> classifyNameVOS = bookGroupClassifyBiz.listClassify(bookGroupId);
        return new ResponseDto<>(classifyNameVOS == null ? new ArrayList<>() : classifyNameVOS);
    }

    @Override
    @GetMapping("getClassifyAndGroupCount")
    public ResponseDto<ClassifyAndGroupCountVO> getClassifyAndGroupCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndGroupCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndGroupCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndGroupCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("getClassifyAndUserCount")
    public ResponseDto<ClassifyAndUserCountVO> getClassifyAndUserCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) {
        ClassifyAndUserCountVO classifyAndGroupCountVO = bookGroupClassifyBiz.getClassifyAndUserCount(bookGroupId);
        return new ResponseDto<>(classifyAndGroupCountVO == null ? new ClassifyAndUserCountVO() : classifyAndGroupCountVO);
    }

    @Override
    @GetMapping("listClassify4Wechat")
    public ResponseDto<List<ListClassify4WechatVO>> listClassify4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<ListClassify4WechatVO> listClassify4WechatVOS = bookGroupClassifyBiz.listClassify4Wechat(bookGroupId, wechatUserId);
        return new ResponseDto<>(listClassify4WechatVOS);
    }

    @Override
    @GetMapping("getGroupQrcode4ClassifyWechat")
    public ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4ClassifyWechat(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        GroupQrcode4ClassifyVO groupQrcode4ClassifyVO = bookGroupClassifyBiz.getGroupQrcode4ClassifyWechat(classifyId, wechatUserId);
        return new ResponseDto<>(groupQrcode4ClassifyVO == null ? new GroupQrcode4ClassifyVO() : groupQrcode4ClassifyVO);
    }

    @Override
    @PostMapping("listGroupQrcodeByAdviser")
    public ResponseDto<PageBeanNew<GroupQrcodeVO>> listGroupQrcodeByAdviser(@RequestHeader("token") String token, @RequestBody ListGroupQrParam listGroupQrParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<GroupQrcodeVO> pageBeanNew = bookGroupClassifyBiz.listGroupQrcodeByAdviser(listGroupQrParam, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("listBookGroupQrcodeStatistic")
    public ResponseDto<PageBeanNew<BookGroupQrcodeStatisticVO>> listBookGroupQrcodeStatistic(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupQrcodeStatisticVO> pageBeanNew = bookGroupClassifyBiz.listBookGroupQrcodeStatistic(listBookGroupQrcodeParamVO, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @PostMapping("bookGroupQrcodeStatisticExport")
    public ResponseDto<?> bookGroupQrcodeStatisticExport(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeExportParamVO listBookGroupQrcodeExportParamVO) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupClassifyBiz.bookGroupQrcodeStatisticExport(listBookGroupQrcodeExportParamVO.getClassifyIds(), listBookGroupQrcodeExportParamVO.getBookGroupId(), adviserId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getStatistic4Adviser")
    public ResponseDto<StatisticVO> getStatistic4Adviser(@RequestHeader("token") String token) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        StatisticVO statisticVO = bookGroupClassifyBiz.getStatistic4Adviser(adviserId);
        return new ResponseDto<>(statisticVO == null ? new StatisticVO() : statisticVO);
    }

}
