package com.pcloud.book.group.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.service.BookGroupService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * Description 社群书内部接口实现类
 * Created by PENG on 2019/5/14.
 */
@RestController("bookGroupService")
@RequestMapping("bookGroupService")
public class BookGroupServiceImpl implements BookGroupService {

    @Autowired
    private BookGroupBiz bookGroupBiz;

    /**
     * 获取社群书基本信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfo",method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupDTO>> getBookGroupInfo(@RequestParam("bookGroupId") Long bookGroupId) throws BizException{
        return ResponseHandleUtil.toResponse(bookGroupBiz.getBookGroupInfo(bookGroupId));
    }
}
