package com.pcloud.book.keywords.biz;

import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.book.keywords.vo.ListKeywordParam;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.book.keywords.vo.SetKeywordVO;
import com.pcloud.book.keywords.vo.SetRankVO;
import com.pcloud.book.keywords.vo.UpdateKeywordVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/25 10:47
 */
public interface BookKeywordBiz {
    /**
     * @Author:lili
     * @Desr:新增关键词
     * @Date:2019/4/25 10:53
     */
    void insertKeyword(SetKeywordVO setKeywordVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:更新关键词
     * @Date:2019/4/25 10:53
     */
    void updateKeyword(UpdateKeywordVO updateKeywordVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:删除关键词
     * @Date:2019/4/25 10:53
     */
    void deleteKeyword(Long keywordId, Long partyId);

    /**
     * @Author:lili
     * @Desr:设置排序值
     * @Date:2019/4/25 10:53
     */
    void setRank(SetRankVO setRankVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:获取分类配置的关键词(为0标识查社群码配置关键词)
     * @Date:2019/4/25 10:54
     */
    PageBeanNew<ListKeywordVO> listKeywordsByClassify(ListKeywordParam listKeywordParam);

    /**
     * @Author:lili
     * @Desr:获取关键词基本信息
     * @Date:2019/4/25 14:36
     */
    KeywordVO getByBookKeyword(Long bookKeywordId);

    /**
     * @Author:lili
     * @Desr: 获取关键词(5个)
     * @Date:2019/5/5 15:11
     */
    List<KeywordDTO> listFiveKeyword(Long classifyId, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr: 回复关键词消息
     * @Date:2019/5/5 16:28
     */
    void sendKeywordMessage(String content, String weixinGroupId, String userWxId);

}
