package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.KeywordDao;
import com.pcloud.book.keywords.entity.Keyword;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/25 11:51
 */
@Component("keywordDao")
public class KeywordDaoImpl extends BaseDaoImpl<Keyword> implements KeywordDao {
    @Override
    public void deleteById(Long keywordId, Long partyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keywordId", keywordId);
        paramMap.put("updateUser", partyId);
        this.getSqlSession().update(this.getStatement("deleteById"), paramMap);
    }
}
