package com.pcloud.book.keywords.facade;

import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.book.keywords.vo.SetGuideVO;
import com.pcloud.book.keywords.vo.UpdateGuideVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/23 15:24
 */
@FeignClient(value = "pcloud-service-book",qualifier = "bookGuideFacadeCloud",path = "bookGuide")
@Api(description = "欢迎语设置")
public interface BookGuideFacade {

    @ApiOperation(value = "设置欢迎语", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "setGuideVO", value = "设置欢迎语参数",  dataType = "SetGuideVO", paramType = "body")
    })
    @PostMapping("insertGuide")
    ResponseDto<?> insertGuide(@RequestHeader("token") String token, @RequestBody SetGuideVO setGuideVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新欢迎语", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateGuideVO", value = "修改欢迎语参数",  dataType = "UpdateGuideVO", paramType = "body")
    })
    @PostMapping("updateGuide")
    ResponseDto<?> updateGuide(@RequestHeader("token") String token, @RequestBody UpdateGuideVO updateGuideVO)
            throws BizException, PermissionException;


    @ApiOperation(value = "根据图书获取欢迎语", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "社群码标识",  dataType = "Long", paramType = "query")
    })
    @GetMapping("getGuideByBookGroup")
    ResponseDto<GuideVO> getGuideByBookGroup(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId)
            throws BizException, PermissionException;


    @ApiOperation(value = "根据分类获取欢迎语", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "分类标识",  dataType = "Long", paramType = "query")
    })
    @GetMapping("getGuideByClassify")
    ResponseDto<GuideVO> getGuideByClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId)
            throws BizException, PermissionException;
}
