package com.pcloud.common.core.biz;

import com.pcloud.common.core.constant.FunnelFlowStruct.FlowNode;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetRoleType;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetType;
import com.pcloud.common.core.dto.FunnelFlowQueueDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 用户漏斗流程消息队列接口
 * @作者： shuyh
 * @创建时间： 2017年5月23日
 * @版本：1.0
 */
public interface FunnelFlowQueueBiz {
	
	/**
	 * 发送消息
	 * @param FunnelFlowQueueDto
	 */
	public void sendMessageQueue(FunnelFlowQueueDto FunnelFlowQueueDto) throws BizException;

	/**
	 * 发送消息
	 * @param targetType   		如：账户、商品、应用
	 * @param targetRoleType 	如：MERCHANT/ADVISER/CHANNEL/OFFICIAL_ACCOUNTS/AGENT
	 * @param flowNode	      	如：流程节点
	 */
	void sendMessageQueue(TargetType targetType, TargetRoleType targetRoleType, FlowNode flowNode, String ip, String userAgent) throws BizException;
	
	/**
	 * 发送消息
	 * @param targetType   		如：账户、商品、应用
	 * @param targetId     		如：账户ID、商品ID、应用ID
	 * @param targetRoleType 	如：MERCHANT/ADVISER/CHANNEL/OFFICIAL_ACCOUNTS/AGENT
	 * @param targetRoleId 		如：MERCHANTID
	 * @param flowNode	      	如：流程节点
	 */
	void sendMessageQueue(TargetType targetType, Long targetId, TargetRoleType targetRoleType,
			Long targetRoleId, FlowNode flowNode) throws BizException;
	
	/**
	 * 发送消息
	 * @param targetType   		如：账户、商品、应用
	 * @param targetId     		如：账户ID、商品ID、应用ID
	 * @param subtypeCode  		如：读者圈(GROUP)
	 * @param targetRoleType 	如：MERCHANT/ADVISER/CHANNEL/OFFICIAL_ACCOUNTS/AGENT
	 * @param targetRoleId 		如：MERCHANTID
	 * @param flowNode	      	如：流程节点
	 */
	void sendMessageQueue(TargetType targetType, Long targetId,
			String subtypeCode, TargetRoleType targetRoleType,
			Long targetRoleId, FlowNode flowNode) throws BizException;

	
	
	
}
