package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.AppletTemplateMessageDto;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.TemplateMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * 
 * @描述：发送模板消息队列实现类
 * @作者：songx
 * @创建时间：2016年11月23日,下午4:53:43 @版本：1.0
 */
@Component("templateQueueBiz")
public class TemplateQueueBizImpl implements TemplateQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 发送模板消息
	 */
	@Override
	@ParamLog("发送模板消息QUEUE")
	public void sendMessageQueue(TemplateMessageDto templateMessageDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.TEMPLATE, templateMessageDto);
	}

	@Override
	@ParamLog("发送小程序模板消息QUEUE")
	public void sendAppletMessageQueue(AppletTemplateMessageDto appletTemplateMessageDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.APPLET_TEMPLATE, appletTemplateMessageDto);
	}

}
