package com.pcloud.common.core.constant;

/**
 * Description 基金资源变更记录操作内容枚举类
 * Created by PENG on 2017/10/18.
 */
public enum FundOperationCodeEnum {

    /**
     * 作品内容修改（不包含协议价变化）
     */
    PRODUCT_INFO("PRODUCT_INFO"),

    /**
     * 应用内容修改（不包含销售价变化）
     */
    APP_INFO("APP_INFO"),

    /**
     * 作品协议价修改
     */
    PRODUCT_DEAL_PRICE("PRODUCT_DEAL_PRICE"),

    /**
     * 作品销售价修改
     */
    PRODUCT_RETAIL_PRICE("PRODUCT_RETAIL_PRICE"),

    /**
     * 应用销售价修改
     */
    APP_RETAIL_PRICE("APP_RETAIL_PRICE"),

    /**
     * 作品删除
     */
    PRODUCT_DELETE("PRODUCT_DELETE"),

    /**
     * 应用删除
     */
    APP_DELETE("APP_DELETE"),

    /**
     * 作品下架
     */
    PRODUCT_OFF_SHELVES("PRODUCT_OFF_SHELVES"),

    /**
     * 作品停止出售
     */
    PRODUCT_OFF_SALE("PRODUCT_OFF_SALE"),

    /**
     * 二维码关联内容修改
     */
    QRCODE_ATTACH("QRCODE_ATTACH"),

    /**
     * 书刊二维码取消关联
     */
    BOOK_QRCODE_DISASSOCIATION("BOOK_QRCODE_DISASSOCIATION"),

    /**
     * 作品资源关联
     */
    PRODUCT_RESOURCE_RELATION("PRODUCT_RESOURCE_RELATION"),

    /**
     * 应用资源关联
     */
    APP_RESOURCE_RELATION("APP_RESOURCE_RELATION"),

    /**
     * 内容修改
     */
    CONTENT_MODIFY("CONTENT_MODIFY"),

    /**
     * 内容删除
     */
    CONTENT_DELETE("CONTENT_DELETE");

    /**
     * 值
     */
    public final String value;

    FundOperationCodeEnum(String value) {
        this.value = value;
    }
}
