package com.pcloud.common.core.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/26 16:56
 **/
@ApiModel("文件压缩包")
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class FileRarDto implements Serializable {

    private static final long serialVersionUID = -5404297263953529753L;

    @ApiModelProperty("文件名称")
    private String fileName;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("文件地址")
    private String fileUrl;

    @ApiModelProperty("文件数量")
    private Integer fileItemCount;

    @ApiModelProperty("压缩状态(-1等待压缩;0正在压缩;1压缩成功;2压缩失败)")
    private Integer state;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Integer getFileItemCount() {
        return fileItemCount;
    }

    public void setFileItemCount(Integer fileItemCount) {
        this.fileItemCount = fileItemCount;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "FileRarDto{" +
                "fileName='" + fileName + '\'' +
                ", fileSize=" + fileSize +
                ", fileUrl='" + fileUrl + '\'' +
                ", fileItemCount=" + fileItemCount +
                ", state=" + state +
                '}';
    }
}
