package com.pcloud.common.core.dto;

import java.io.Serializable;
import java.util.Date;

import com.pcloud.common.core.constant.FunnelFlowStruct.FlowNode;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetRoleType;
import com.pcloud.common.core.constant.FunnelFlowStruct.TargetType;

public class FunnelFlowQueueDto implements Serializable {

	private static final long serialVersionUID = 5482560365870913235L;

	private Long id;

    private Long targetId;

    private String targetType;

    private String subtypeCode;

    private String subtypeName;

    private Long targetRoleId;

    private String targetRoleType;
    
    private String targetRoleIp;
    
    private String targetRolePathId;
    
    private String targetRoleClient;

    private Long flowId;

    private Long nodeId;

    private Date nodeDate;

    private String tempMark;

    private Long dayDigit;

    private Date dayDate;

    private Date createdDate;

    private Date lastModifiedDate;

    private Integer version;
    
    public FunnelFlowQueueDto() {
    	
	}

    /**
     * Ӧ���ڣ���targetId����targetRoleId����ע������
     * @param targetType
     * @param targetRoleType
     * @param flowNode
     */
	public FunnelFlowQueueDto(TargetType targetType, TargetRoleType targetRoleType, FlowNode flowNode, String ip, String userAgent) {
		this.targetType = targetType.name();
		this.targetRoleType = targetRoleType.name();
		this.targetRoleIp = ip;
		this.targetRoleClient = userAgent;
		this.flowId = flowNode.getFlowId();
		this.nodeId = flowNode.getId();
		this.nodeDate = new Date();
		this.createdDate = new Date();
		this.lastModifiedDate = new Date();
		this.version = 1;
	}

	/**
	 * ����ʹ��Ӧ���ڣ���Ʒ��Ӧ�����̣���Ŀ�������ͣ�
	 * @param targetType
	 * @param targetId
	 * @param targetRoleType
	 * @param targetRoleId
	 * @param flowNode
	 */
	public FunnelFlowQueueDto(TargetType targetType, Long targetId, TargetRoleType targetRoleType, Long targetRoleId, FlowNode flowNode) {
		this.targetType = targetType.name();
		this.targetId = targetId;
		this.targetRoleType = targetRoleType.name();
		this.targetRoleId = targetRoleId;
		this.flowId = flowNode.getFlowId();
		this.nodeId = flowNode.getId();
		this.nodeDate = new Date();
		this.createdDate = new Date();
		this.lastModifiedDate = new Date();
		this.version = 1;
	}

	/**
	 * ����ʹ��Ӧ���ڣ���Ʒ��Ӧ������
	 * @param targetType
	 * @param targetId
	 * @param subtypeCode Ŀ��������
	 * @param targetRoleType
	 * @param targetRoleId
	 * @param flowNode
	 */
	public FunnelFlowQueueDto(TargetType targetType, Long targetId, String subtypeCode, TargetRoleType targetRoleType, Long targetRoleId, FlowNode flowNode) {
		this.targetType = targetType.name();
		this.targetId = targetId;
		this.subtypeCode = subtypeCode;
		this.targetRoleType = targetRoleType.name();
		this.targetRoleId = targetRoleId;
		this.flowId = flowNode.getFlowId();
		this.nodeId = flowNode.getId();
		this.nodeDate = new Date();
		this.createdDate = new Date();
		this.lastModifiedDate = new Date();
		this.version = 1;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public String getTargetType() {
        return targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getSubtypeCode() {
        return subtypeCode;
    }

    public void setSubtypeCode(String subtypeCode) {
        this.subtypeCode = subtypeCode;
    }

    public String getSubtypeName() {
        return subtypeName;
    }

    public void setSubtypeName(String subtypeName) {
        this.subtypeName = subtypeName;
    }

    public Long getTargetRoleId() {
        return targetRoleId;
    }

    public void setTargetRoleId(Long targetRoleId) {
        this.targetRoleId = targetRoleId;
    }

    public String getTargetRoleType() {
        return targetRoleType;
    }

    public void setTargetRoleType(String targetRoleType) {
        this.targetRoleType = targetRoleType;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Long getNodeId() {
        return nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public Date getNodeDate() {
        return nodeDate;
    }

    public void setNodeDate(Date nodeDate) {
        this.nodeDate = nodeDate;
    }

    public String getTempMark() {
        return tempMark;
    }

    public void setTempMark(String tempMark) {
        this.tempMark = tempMark;
    }

    public Long getDayDigit() {
        return dayDigit;
    }

    public void setDayDigit(Long dayDigit) {
        this.dayDigit = dayDigit;
    }

    public Date getDayDate() {
        return dayDate;
    }

    public void setDayDate(Date dayDate) {
        this.dayDate = dayDate;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

	public String getTargetRoleIp() {
		return targetRoleIp;
	}

	public void setTargetRoleIp(String targetRoleIp) {
		this.targetRoleIp = targetRoleIp;
	}

	public String getTargetRolePathId() {
		return targetRolePathId;
	}

	public void setTargetRolePathId(String targetRolePathId) {
		this.targetRolePathId = targetRolePathId;
	}

	public String getTargetRoleClient() {
		return targetRoleClient;
	}

	public void setTargetRoleClient(String targetRoleClient) {
		this.targetRoleClient = targetRoleClient;
	}
    
    
}