package com.pcloud.common.constant;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import com.pcloud.common.utils.FileUtils;
import com.pcloud.common.utils.string.StringUtil;

/**
 * 
 * 
 * @author：songx
 * @date：2018年6月25日,下午7:30:21
 */
@Component("aliyunConstant")
@PropertySource(value = { "classpath:aliyun.properties" })
public class AliyunConstant {

	/**
	 * 主账号keyId，华为云ak
	 */
	public static String MAIN_ACCESS_KEY_ID;

	@Value("${main.access.key.id}")
	public void setMainAccessKeyId(String mainAccessKeyId) {
		MAIN_ACCESS_KEY_ID = mainAccessKeyId;
	}

	/**
	 * 主账号keySecret 华为云sk
	 */
	public static String MAIN_ACCESS_KEY_SECRET;

	@Value("${main.access.key.secret}")
	public void setMainAccessKeySecret(String mainAccessKeySecret) {
		MAIN_ACCESS_KEY_SECRET = mainAccessKeySecret;
	}

	/**
	 * 媒体转码,华东地区
	 */
	public static String MTS_REGION;

	@Value("${mts.region}")
	public void setMtsRegion(String mtsRegion) {
		MTS_REGION = mtsRegion;
	}

	/**
	 * 媒体转码,华北地区
	 */
	public static String MTS_REGION_BJ;

	@Value("cn-north-4")
	public void setMtsRegionBj(String mtsRegionBj) {
		MTS_REGION_BJ = mtsRegionBj;
	}

	/**
	 * OSS,华东地区
	 */
	public static String OSS_REGION;

	@Value("${oss.region}")
	public void setOssRegion(String ossRegion) {
		OSS_REGION = ossRegion;
	}

	/**
	 * OSS,华北地区
	 */
	public static String OSS_REGION_BJ;

	@Value("cn-north-4")
	public void setOssRegionBj(String ossRegionBj) {
		OSS_REGION_BJ = ossRegionBj;
	}

	/**
	 * OSS endpoind地址(华东地区1)
	 */
	public static String OSS_ENDPOINT;

	@Value("${oss.endpoint}")
	public void setOssEndpoint(String ossEndpoint) {
		OSS_ENDPOINT = ossEndpoint;
	}

	/**
	 * OSS endpoind地址(华北地区1)
	 */
	public static String OSS_ENDPOINT_BJ;

	@Value("${oss.endpoint.bj}")
	public void setOssEndpointBj(String ossEndpointBj) {
		OSS_ENDPOINT_BJ = ossEndpointBj;
	}

	/**
	 * 媒体转码endpoind地址,华东地区
	 */
	public static String MTS_ENDPOINT;

	@Value("${mts.endpoint}")
	public void setMtsEndpoint(String mtsEndpoint) {
		MTS_ENDPOINT = mtsEndpoint;
	}

	/**
	 * 媒体转码endpoind地址,华北地区
	 */
	public static String MTS_ENDPOINT_BJ;

	@Value("live.cn-north-4.myhuaweicloud.com")
	public void setMtsEndpointBj(String mtsEndpointBj) {
		MTS_ENDPOINT_BJ = mtsEndpointBj;
	}

	/**
	 * 管道ID
	 */
	public static String PIPELINEID;

	@Value("${pipelineid}")
	public void setPipelineid(String pipelineid) {
		PIPELINEID = pipelineid;
	}

	/**
	 * 管道ID(华北地区)
	 */
	public static String PIPELINEID_BJ;

	@Value("${pipelineid.bj}")
	public void setPipelineidBj(String pipelineidBj) {
		PIPELINEID_BJ = pipelineidBj;
	}

	/**
	 * 设置用户项目编号ProjectId
	 */
	public static String PROJECT_ID;

	@Value("${mts.projectId}")
	public  void setProjectId(String projectId) {
		PROJECT_ID = projectId;
	}

	/**
	 * 转MP3模板ID
	 */
	public static String MP3_TEMPLATE_ID;

	@Value("${mp3TemplateId}")
	public void setMp3TemplateId(String mp3TemplateId) {
		MP3_TEMPLATE_ID = mp3TemplateId;
	}

	/**
	 * 转MP3模板ID(华北地区)
	 */
	public static String MP3_TEMPLATE_ID_BJ;

	@Value("${mp3TemplateId.bj}")
	public void setMp3TemplateIdBj(String mp3TemplateIdBj) {
		MP3_TEMPLATE_ID_BJ = mp3TemplateIdBj;
	}

	/**
	 * 转M3U8模板ID
	 */
	public static String M3U8_TEMPLATE_ID;

	@Value("${m3u8TemplateId}")
	public void setM3u8TemplateId(String m3u8TemplateId) {
		M3U8_TEMPLATE_ID = m3u8TemplateId;
	}

	/**
	 * 转MP4模板ID
	 */
	public static String MP4_TEMPLATE_ID;

	@Value("${mp4TemplateId}")
	public void setMp4TemplateId(String mp4TemplateId) {
		MP4_TEMPLATE_ID = mp4TemplateId;
	}

	/**
	 * 转MP4模板ID(华北地区)
	 */
	public static String MP4_TEMPLATE_ID_BJ;

	@Value("125799")
	public void setMp4TemplateIdBj(String mp4TemplateIdBj) {
		MP4_TEMPLATE_ID_BJ = mp4TemplateIdBj;
	}

	/**
	 * OSS存储输入地址
	 */
	public static String INPUT_BUCKET;

	@Value("${input.bucket}")
	public void setInputBucket(String imputBucket) {
		INPUT_BUCKET = imputBucket;
	}

	/**
	 * OSS存储输出地址
	 */
	public static String FILE_BUCKET;

	@Value("${file.bucket}")
	public void setFileBucket(String fileBucket) {
		FILE_BUCKET = fileBucket;
	}

	/**
	 * 直播OSS存储输出地址,开发环境
	 */
	public static String LIVE_BUCKET;

	@Value("${live.bucket}")
	public void setLiveBucket(String liveBucket) {
		LIVE_BUCKET = liveBucket;
	}

	/**
	 * IOS直播OSS存储输出地址,开发环境
	 */
	public static final String IOS_TEST_BUCKET = "whlg-oss-iostest";

	/**
	 * 版元存储输出地址
	 */
	public static String BY_BUCKET;

	@Value("${by.bucket}")
	public void setByBucket(String byBucket){
		BY_BUCKET = byBucket;
	}

	/**
	 * 开发存储输出地址
	 */
	public static final String DEV_BUCKET = "whlg-oss-dev-002";

	/**
	 * 测试存储输出地址
	 */
	public static final String TEST_BUCKET = "whlg-oss-test-002";

	/**
	 * UAT存储输出地址
	 */
	public static final String UAT_BUCKET = "whlg-oss-uat-002";

	/**
	 * OSS 鉴权KEY(仅限下载用)
	 */
	public static final String OSS_PRIVATE_KEY = "WhlgFileDownload1608";

	/**
	 * OSS 鉴权默认有效时间
	 */
	public static final int OSS_DEFAULT_TIME = 48 * 60 * 60;

	/**
	 * OSS 鉴权长期有效，50年
	 */
	public static final int OSS_LONG_TIME = 50 * 365 * 24 * 60 * 60;

	/**
	 * RAYS OSS的域名
	 */
	public static String[] RAYS_CDN_URLS;

	@Value("${rays.cdn.urls}")
	public void setRaysCdnUrls(String raysCdnUrls) {
		RAYS_CDN_URLS = raysCdnUrls.split(",");
	}

	/**
	 * oss FILE域名,HTTPS
	 */
	public static String[] OSS_CDN_URLS;

	@Value("${oss.cdn.urls}")
	public void setOssCdnUrls(String ossCdnUrls) {
		OSS_CDN_URLS = ossCdnUrls.split(",");
	}

	/**
	 * OSS CDN域名,HTTPS
	 */
	public static String FILE_CDN_URL;

	@Value("${file.cdn.url}")
	public void setFileCdnUrl(String fileCdnUrl) {
		FILE_CDN_URL = fileCdnUrl;
	}

	/**
	 * OSS CDN域名,HTTPS(直播)
	 */
	public static String FILE_CDN_URL_LIVE;

	@Value("${file.cdn.url.live}")
	public void setFileCdnUrlLive(String fileCdnUrlLive) {
		FILE_CDN_URL_LIVE = fileCdnUrlLive;
	}

	/**
	 * OSS CDN域名,HTTPS(直播)
	 */
	public static String FILE_CDN_URL_BY;

	@Value("${file.cdn.url.by}")
	public void setFileCdnUrlBy(String fileCdnUrlBy) {
		FILE_CDN_URL_BY = fileCdnUrlBy;
	}

	/**
	 * OSS CDN域名(下载使用)
	 */
	public static String FILE_CDN_URL_DOWNLOAD;

	@Value("${file.cdn.url.download}")
	public void setFileCdnUrlDownload(String fileCdnUrlDownload) {
		FILE_CDN_URL_DOWNLOAD = fileCdnUrlDownload;
	}

	/**
	 * OSS 原始文件路径
	 */
	public static String FILE_ORIGINAL_URL;

	@Value("${file.original.url}")
	public void setFileOriginalUrl(String fileOriginalUrl) {
		FILE_ORIGINAL_URL = fileOriginalUrl;
	}

	/**
	 * OSS 原始文件路径(直播)
	 */
	public static String LIVE_ORIGINAL_URL;

	@Value("${live.original.url}")
	public void setLiveOriginalUrl(String liveOriginalUrl) {
		LIVE_ORIGINAL_URL = liveOriginalUrl;
	}

	/**
	 * OSS 原始文件路径(版元)
	 */
	public static String BY_ORIGINAL_URL;

	@Value("${by.original.url}")
	public void setByOriginalUrl(String byOriginalUrl) {
		BY_ORIGINAL_URL = byOriginalUrl;
	}


	/**
	 * 华为云转码ak
	 */
	public static String MtsAK;

	@Value("${mts.ak}")
	public  void setMtsAK(String mtsAK) {
		MtsAK = mtsAK;
	}

	/**
	 * 华为云转码sk
	 */
	public static String MtsSK;

	@Value("${mts.sk}")
	public  void setMtsSK(String mtsSK) {
		MtsSK = mtsSK;
	}


	/**
	 * 视频水印模板ID-左下角
	 */
	public static final String WATERMARK_BOTTOM_LEFT = "cb8fe5517c5a44c19284cdf130dd223d";


	/**
	 * 华为云Access Key
	 */
	public static String ACCESS_KEY;

	@Value("${huawei.access.key}")
	public  void setAccessKey(String accessKey) {
		ACCESS_KEY = accessKey;
	}

	/**
	 * 华为云 Secret Key
	 */
	public static String  SECRET_KEY;

	@Value("${huawei.secret.key}")
	public static void setSecretKey(String secretKey) {
		SECRET_KEY = secretKey;
	}


	/**
	 * 根据域名获取bucket名称
	 *
	 * @param fileUrl
	 * @return
	 */
	public static String getBucketName(String fileUrl) {
		if (StringUtil.isEmpty(fileUrl)) {
			return null;
		}
		if (fileUrl.contains("transcode")){
			return FILE_BUCKET;
		}
		String domainName = FileUtils.getDomainName(fileUrl);
		if (StringUtil.isEmpty(domainName)) {
			return INPUT_BUCKET;
		}
		//不根据域名判断
		switch (domainName) {
//			case "file.chubanyun.me":
//				return DEV_BUCKET;
//			case "file.techdc.cn":
//			case "file.raysgo.com":
//			case "oss.raysgo.com":
//				return TEST_BUCKET;
//			case "file.raysyun.com":
//				return UAT_BUCKET;
			case "live.chubanyun.me":
				return LIVE_BUCKET;
			case "rays-adviser.chubanyun.me":
				return IOS_TEST_BUCKET;
			case "byfile.1wlshu.com":
			case "byfile.raysgo.com":
				return BY_BUCKET;
//			case "file.5rs.me":
//			case "oss.5rs.me":
//			case "download.5rs.me":
//				return FILE_BUCKET;
			default:
				return FILE_BUCKET;
		}
	}

	/**
	 * 获取OSS地域名称
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getOssRegion(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return OSS_REGION_BJ;
		} else {
			return OSS_REGION;
		}
	}

	/**
	 * 获取媒体转码地域名称
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getMtsRegion(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return MTS_REGION_BJ;
		} else {
			return MTS_REGION;
		}
	}

	/**
	 * 获取媒体转码EndPoint
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getMtsEndPoint(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return MTS_ENDPOINT_BJ;
		} else {
			return MTS_ENDPOINT;
		}
	}

	/**
	 * 获取OSS输出bucket
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getOutBucket(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return LIVE_BUCKET;
		} else if (BY_BUCKET.equals(bucketName)) {
			return BY_BUCKET;
		} else {
			return FILE_BUCKET;
		}
	}

	/**
	 * 获取转码管道ID
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getPipelineId(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return PIPELINEID_BJ;
		} else {
			return PIPELINEID;
		}
	}

	/**
	 * 获取MP3转码模板ID
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getMp3TemplateId(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return MP3_TEMPLATE_ID_BJ;
		} else {
			return MP3_TEMPLATE_ID;
		}
	}

	/**
	 * 获取MP4转码模板ID
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getMp4TemplateId(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return MP4_TEMPLATE_ID_BJ;
		} else {
			return MP4_TEMPLATE_ID;
		}
	}

	/**
	 * 获取视频转码模板ID
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getVideoTemplateId(String bucketName, String outFileType) {
		if (StringUtil.isEmpty(outFileType)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return MP4_TEMPLATE_ID_BJ;
		} else if ("m3u8".equalsIgnoreCase(outFileType)) {
			return M3U8_TEMPLATE_ID;
		} else {
			return MP4_TEMPLATE_ID;
		}
	}

	/**
	 * 获取文件CDN地址
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getOSSCDNUrl(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return FILE_CDN_URL_LIVE;
		} else if (BY_BUCKET.equals(bucketName)) {
			return FILE_CDN_URL_BY;
		} else {
			return FILE_CDN_URL;
		}
	}

	/**
	 * 获取OSS原始地址
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getOSSOriginalUrl(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return LIVE_ORIGINAL_URL;
		} else if (BY_BUCKET.equals(bucketName)) {
			return BY_ORIGINAL_URL;
		} else {
			return FILE_ORIGINAL_URL;
		}
	}

	/**
	 * 获取OSS EndPoint地址
	 *
	 * @param bucketName
	 * @return
	 */
	public static String getOSSEndPoint(String bucketName) {
		if (StringUtil.isEmpty(bucketName)) {
			return null;
		}
		if (LIVE_BUCKET.equals(bucketName)) {
			return OSS_ENDPOINT_BJ;
		} else {
			return OSS_ENDPOINT;
		}
	}

}
