package com.pcloud.common.constant;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: AppLabelConstant
 * @Description: 现代纸书APP 标签常量
 * @Auther: lihao
 * @Date: 2019/11/25 14:28
 */
@Component("appLabelConstant")
@PropertySource(value = { "classpath:app_label.properties" })
public class AppLabelConstant {

    public static final String GRADE1 = "一年级";

    public static final String GRADE2 = "二年级";

    public static final String GRADE3 = "三年级";

    public static final String GRADE4 = "四年级";

    public static final String GRADE5 = "五年级";

    public static final String GRADE6 = "六年级";

    public static final String GRADE7 = "初一";

    public static final String GRADE8 = "初二";

    public static final String GRADE9 = "初三";

    public static final String GRADE10 = "高一";

    public static final String GRADE11 = "高二";

    public static final String GRADE12 = "高三";

    /**
     * 1年级标签
     */
    public static List<Long> GRADE1_LABEL_IDS;
    @Value("#{'${grade1}'.split(',')}")
    public void setGrade1LabelIds(List<Long> grade1LabelIds) {
        GRADE1_LABEL_IDS = grade1LabelIds;
    }

    /**
     * 2年级
     */
    public static List<Long> GRADE2_LABEL_IDS;
    @Value("#{'${grade2}'.split(',')}")
    public void setGrade2LabelIds(List<Long> grade2LabelIds) {
        GRADE2_LABEL_IDS = grade2LabelIds;
    }

    /**
     * 3年级
     */
    public static List<Long> GRADE3_LABEL_IDS;
    @Value("#{'${grade3}'.split(',')}")
    public void setGrade3LabelIds(List<Long> grade3LabelIds) {
        GRADE3_LABEL_IDS = grade3LabelIds;
    }

    /**
     * 4年级
     */
    public static List<Long> GRADE4_LABEL_IDS;
    @Value("#{'${grade4}'.split(',')}")
    public void setGrade4LabelIds(List<Long> grade4LabelIds) {
        GRADE4_LABEL_IDS = grade4LabelIds;
    }

    /**
     * 5年级
     */
    public static List<Long> GRADE5_LABEL_IDS;
    @Value("#{'${grade5}'.split(',')}")
    public void setGrade5LabelIds(List<Long> grade5LabelIds) {
        GRADE5_LABEL_IDS = grade5LabelIds;
    }

    /**
     * 6年级
     */
    public static List<Long> GRADE6_LABEL_IDS;
    @Value("#{'${grade6}'.split(',')}")
    public void setGrade6LabelIds(List<Long> grade6LabelIds) {
        GRADE6_LABEL_IDS = grade6LabelIds;
    }

    /**
     * 7年级
     */
    public static List<Long> GRADE7_LABEL_IDS;
    @Value("#{'${grade7}'.split(',')}")
    public void setGrade7LabelIds(List<Long> grade7LabelIds) {
        GRADE7_LABEL_IDS = grade7LabelIds;
    }

    /**
     * 8年级
     */
    public static List<Long> GRADE8_LABEL_IDS;
    @Value("#{'${grade8}'.split(',')}")
    public void setGrade8LabelIds(List<Long> grade8LabelIds) {
        GRADE8_LABEL_IDS = grade8LabelIds;
    }

    /**
     * 9年级
     */
    public static List<Long> GRADE9_LABEL_IDS;
    @Value("#{'${grade9}'.split(',')}")
    public void setGrade9LabelIds(List<Long> grade9LabelIds) {
        GRADE9_LABEL_IDS = grade9LabelIds;
    }

    /**
     * 高一
     */
    public static List<Long> GRADE10_LABEL_IDS;
    @Value("#{'${grade10}'.split(',')}")
    public void setGrade10LabelIds(List<Long> grade10LabelIds) {
        GRADE10_LABEL_IDS = grade10LabelIds;
    }

    /**
     * 高二
     */
    public static List<Long> GRADE11_LABEL_IDS;
    @Value("#{'${grade11}'.split(',')}")
    public void setGrade11LabelIds(List<Long> grade11LabelIds) {
        GRADE11_LABEL_IDS = grade11LabelIds;
    }

    /**
     * 高三
     */
    public static List<Long> GRADE12_LABEL_IDS;
    @Value("#{'${grade12}'.split(',')}")
    public void setGrade12LabelIds(List<Long> grade12LabelIds) {
        GRADE12_LABEL_IDS = grade12LabelIds;
    }

    /**
     * 科目-所有
     */
    public static List<Long> SUBJECT_ALL_LABEL_IDS;
    @Value("#{'${subject.all}'.split(',')}")
    public void setAllSubjectLabelIds(List<Long> allSubjectLabelIds) {
        SUBJECT_ALL_LABEL_IDS = allSubjectLabelIds;
    }

    /**
     * 科目-语文
     */
    public static Long CHINESE_LABEL_ID;
    @Value("${subject.chinese}")
    public void setChineseLabelId(Long chineseLabelId) {
        CHINESE_LABEL_ID = chineseLabelId;
    }

    /**
     * 科目-数学
     */
    public static Long MATH_LABEL_ID;
    @Value("${subject.math}")
    public void setMathLabelId(Long mathLabelId) {
        MATH_LABEL_ID = mathLabelId;
    }

    /**
     * 科目-英语
     */
    public static Long ENGLISH_LABEL_ID;
    @Value("${subject.english}")
    public void setEnglishLabelId(Long englishLabelId) {
        ENGLISH_LABEL_ID = englishLabelId;
    }

    /**
     * 科目-物理
     */
    public static Long PHYSICS_LABEL_ID;
    @Value("${subject.physics}")
    public void setPhysicsLabelId(Long physicsLabelId) {
        PHYSICS_LABEL_ID = physicsLabelId;
    }

    /**
     * 科目-化学
     */
    public static Long CHEMISTRY_LABEL_ID;
    @Value("${subject.chemistry}")
    public void setChemistryLabelId(Long chemistryLabelId) {
        CHEMISTRY_LABEL_ID = chemistryLabelId;
    }

    /**
     * 科目-生物
     */
    public static Long BIOLOGY_LABEL_ID;
    @Value("${subject.biology}")
    public void setBiologyLabelId(Long biologyLabelId) {
        BIOLOGY_LABEL_ID = biologyLabelId;
    }

    /**
     * 科目-历史
     */
    public static Long HISTORY_LABEL_ID;
    @Value("${subject.history}")
    public void setHistoryLabelId(Long historyLabelId) {
        HISTORY_LABEL_ID = historyLabelId;
    }

    /**
     * 科目-地理
     */
    public static Long GEOGRAPHY_LABEL_ID;
    @Value("${subject.geography}")
    public void setGeographyLabelId(Long geographyLabelId) {
        GEOGRAPHY_LABEL_ID = geographyLabelId;
    }

    /**
     * 科目标签枚举
     */
    public enum SubjectLabelEnum{

        CHINESE(CHINESE_LABEL_ID, "语文"),
        MATH(MATH_LABEL_ID, "数学"),
        ENGLISH(ENGLISH_LABEL_ID, "英语"),
        PHYSICS(PHYSICS_LABEL_ID, "物理"),
        CHEMISTRY(CHEMISTRY_LABEL_ID, "化学"),
        BIOLOGY(BIOLOGY_LABEL_ID, "生物"),
        HISTORY(HISTORY_LABEL_ID, "历史"),
        GEOGRAPHY(GEOGRAPHY_LABEL_ID, "地理");

        private Long labelId;
        private String labelName;

        SubjectLabelEnum(Long labelId, String labelName){
            this.labelId = labelId;
            this.labelName = labelName;
        }

        public Long getLabelId() {
            return labelId;
        }

        public String getLabelName() {
            return labelName;
        }

    }

    /**
     * 根据年级标签获取年级深度标签
     */
    public static List<Long> getGradeDepLabelIds(String grade) {
        switch (grade) {
            case AppLabelConstant.GRADE1:
                return AppLabelConstant.GRADE1_LABEL_IDS;
            case AppLabelConstant.GRADE2:
                return AppLabelConstant.GRADE2_LABEL_IDS;
            case AppLabelConstant.GRADE3:
                return AppLabelConstant.GRADE3_LABEL_IDS;
            case AppLabelConstant.GRADE4:
                return AppLabelConstant.GRADE4_LABEL_IDS;
            case AppLabelConstant.GRADE5:
                return AppLabelConstant.GRADE5_LABEL_IDS;
            case AppLabelConstant.GRADE6:
                return AppLabelConstant.GRADE6_LABEL_IDS;
            case AppLabelConstant.GRADE7:
                return AppLabelConstant.GRADE7_LABEL_IDS;
            case AppLabelConstant.GRADE8:
                return AppLabelConstant.GRADE8_LABEL_IDS;
            case AppLabelConstant.GRADE9:
                return AppLabelConstant.GRADE9_LABEL_IDS;
            case AppLabelConstant.GRADE10:
                return AppLabelConstant.GRADE10_LABEL_IDS;
            case AppLabelConstant.GRADE11:
                return AppLabelConstant.GRADE11_LABEL_IDS;
            case AppLabelConstant.GRADE12:
                return AppLabelConstant.GRADE12_LABEL_IDS;
            default:
                return new ArrayList<>();
        }
    }

}
