/**
 * 
 */
package com.pcloud.common.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * @描述：DTO父类
 * @作者：songx
 * @创建时间：2016年9月1日,上午9:06:13 @版本：1.0
 */
@JsonInclude(value = Include.NON_NULL)
public class BaseDto implements Serializable {

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1791012797754220617L;

	/**
	 * 是否包含敏感词
	 */
	private Boolean hasSensitive;

	/**
	 * 版本
	 */
	@JsonInclude(value = Include.NON_DEFAULT)
	private Integer version = 0;

	/**
	 * 创建人
	 */
	private Long createdUser;

	/**
	 * 创建时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date createdDate;

	/**
	 * 最后修改人
	 */
	private Long lastModifiedUser;

	/**
	 * 最后修改时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date lastModifiedDate;

	public Boolean getHasSensitive() {
		return hasSensitive;
	}

	public void setHasSensitive(Boolean hasSensitive) {
		this.hasSensitive = hasSensitive;
	}

	public Long getLastModifiedUser() {
		return lastModifiedUser;
	}

	public void setLastModifiedUser(Long lastModifiedUser) {
		this.lastModifiedUser = lastModifiedUser;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getLastModifiedDate() {
		return lastModifiedDate;
	}

	public void setLastModifiedDate(Date lastModifiedDate) {
		this.lastModifiedDate = lastModifiedDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Long getCreatedUser() {
		return createdUser;
	}

	public void setCreatedUser(Long createdUser) {
		this.createdUser = createdUser;
	}

	@JsonInclude(value = Include.NON_DEFAULT)
	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

}
