package com.pcloud.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Describe: 商城用户已购买的应用或作品dto
 * @Author: zhangdongwei
 * @Date: Create on 18:16 2019/8/7 0007
 */
@ApiModel("商城用户已购买的应用或作品dto")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class StoreMyPayDto {
    /**
     * 标识（appId/productId/bookGroupId）
     */
    @ApiModelProperty("标识(appId/productId/bookGroupId)")
    private Long originId;
    /**
     * 类型(APP/PRODUCT/BOOK_GROUP)
     */
    @ApiModelProperty("类型(APP/PRODUCT/BOOK_GROUP)")
    private String originType;
    /**
     * 具体类型编码
     */
    @ApiModelProperty("具体类型")
    private String typeCode;
    /**
     * 具体类型名称
     */
    private String typeName;
    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String originName;
    /**
     * 封面图片
     */
    @ApiModelProperty("封面图片")
    private String coverImg;
    /**
     * 简介
     */
    @ApiModelProperty("简介")
    private String description;
    /**
     * 价格
     */
    @ApiModelProperty("价格")
    private BigDecimal price;
    /**
     * 是否支持单节购买
     */
    @ApiModelProperty("是否支持单节购买")
    private Integer isSaleOne;
    /**
     * 已经购买的资源数量
     */
    @ApiModelProperty("已经购买的资源数量")
    private Integer resourceNum;
    /**
     * 购买时间
     */
    @ApiModelProperty("购买时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date payTime;
    /**
     *总课时数
     */
    @ApiModelProperty("总课时数")
    private Integer totalCourseNum;
    /**
     * 已开课节数
     */
    @ApiModelProperty("已开课节数")
    private Integer openCourseNum;

    /**
     * 用户已打卡天数
     */
    @ApiModelProperty("用户已打卡天数")
    private Integer clockDayNum;
    
    @ApiModelProperty("会员有效期天数")
    private Long overDay;
    
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("开始时间")
    private Date createTime;
    
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("结束时间")
    private Date endTime;
    
    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getOriginName() {
        return originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getIsSaleOne() {
        return isSaleOne;
    }

    public void setIsSaleOne(Integer isSaleOne) {
        this.isSaleOne = isSaleOne;
    }

    public Integer getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(Integer resourceNum) {
        this.resourceNum = resourceNum;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Integer getTotalCourseNum() {
        return totalCourseNum;
    }

    public void setTotalCourseNum(Integer totalCourseNum) {
        this.totalCourseNum = totalCourseNum;
    }

    public Integer getOpenCourseNum() {
        return openCourseNum;
    }

    public void setOpenCourseNum(Integer openCourseNum) {
        this.openCourseNum = openCourseNum;
    }

    public Integer getClockDayNum() {
        return clockDayNum;
    }

    public void setClockDayNum(Integer clockDayNum) {
        this.clockDayNum = clockDayNum;
    }
    
    public String getDescription() {
        return description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    public Long getOverDay() {
        return overDay;
    }
    
    public void setOverDay(Long overDay) {
        this.overDay = overDay;
    }
    
    public Date getCreateTime() {
        return createTime;
    }
    
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
    
    public Date getEndTime() {
        return endTime;
    }
    
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    
    @Override
    public String toString() {
        return "StoreMyPayDto{" +
                "originId=" + originId +
                ", originType='" + originType + '\'' +
                ", typeCode='" + typeCode + '\'' +
                ", typeName='" + typeName + '\'' +
                ", originName='" + originName + '\'' +
                ", coverImg='" + coverImg + '\'' +
                ", description='" + description + '\'' +
                ", price=" + price +
                ", isSaleOne=" + isSaleOne +
                ", resourceNum=" + resourceNum +
                ", payTime=" + payTime +
                ", totalCourseNum=" + totalCourseNum +
                ", openCourseNum=" + openCourseNum +
                ", clockDayNum=" + clockDayNum +
                ", overDay=" + overDay +
                ", createTime=" + createTime +
                ", endTime=" + endTime +
                '}';
    }
}
