package com.pcloud.common.entity;

import java.io.Serializable;

/**
 * 分页请求VO基类，基于pageHelper插件使用
 *
 * @author：songx
 * @date：2019/5/15,16:19
 */
public class BasePageVO implements Serializable {

    private static final long serialVersionUID = -4108243803635720730L;

    /**
     * 每页条数
     */
    private Integer numPerPage;

    /**
     * 当前页数
     */
    private Integer currentPage;

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public Integer getCurrentPage() {
        // pageHelper插件第一页从1开始，与前端约定分页查询从0开始，故需要+1
        return currentPage == null ? 1 : currentPage + 1;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }
}
